/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private Screen parentScreen;
    private LayoutButtonStates states = new LayoutButtonStates();
    private Mappings.Entry entry;
    private Button doneButton;
    private Button resetButton;
    private Button thumbstickButton;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("controllable.gui.title.layout", new Object[0]));
        this.parentScreen = parentScreen;
        Controller controller = Controllable.getController();
        if (controller != null) {
            Mappings.Entry entry = controller.getMapping();
            this.entry = entry != null ? entry.copy() : new Mappings.Entry(controller.getName(), controller.getName(), new HashMap<Integer, Integer>());
        }
    }

    protected void init() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 154, this.height - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.save", (Object[])new Object[0]), button -> {
            this.updateControllerMapping();
            this.minecraft.func_147108_a(this.parentScreen);
        }));
        this.resetButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 50, this.height - 32, 100, 20, I18n.func_135052_a((String)"controllable.gui.reset", (Object[])new Object[0]), button -> {
            this.entry.getReassignments().clear();
            this.entry.setSwitchThumbsticks(false);
            this.entry.setFlipLeftX(false);
            this.entry.setFlipLeftY(false);
            this.entry.setFlipRightX(false);
            this.entry.setFlipRightY(false);
        }));
        this.addButton((Widget)new Button(this.width / 2 + 54, this.height - 32, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.minecraft.func_147108_a(this.parentScreen)));
        int width = 190;
        int x = this.width / 2 - width / 2;
        int y = this.height / 2 - 50 - 35;
        this.thumbstickButton = (Button)this.addButton((Widget)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> this.minecraft.func_147108_a((Screen)new ThumbstickSettingsScreen(this))));
    }

    public void tick() {
        boolean changed = !this.entry.getReassignments().isEmpty();
        changed |= this.entry.isThumbsticksSwitched();
        changed |= this.entry.isFlipLeftX();
        changed |= this.entry.isFlipLeftY();
        changed |= this.entry.isFlipRightX();
        this.resetButton.active = changed |= this.entry.isFlipRightY();
        this.validLayout = this.entry.getReassignments().values().stream().noneMatch(b -> b == -1);
        this.doneButton.setMessage(new TranslationTextComponent("controllable.gui.save", new Object[0]).func_211708_a(this.validLayout ? TextFormatting.WHITE : TextFormatting.RED).func_150254_d());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        ArrayList<String> components;
        this.renderDirtBackground(0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 190;
        int height = 120;
        int x = this.width / 2 - width / 2;
        int y = this.height / 2 - 50 - 35;
        ControllerLayoutScreen.blit((int)x, (int)y, (int)width, (int)height, (float)50.0f, (float)0.0f, (int)38, (int)24, (int)256, (int)256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(x, y, mouseX, mouseY, this.configureButton == controllerButton.button));
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        this.drawMultiLineCenteredString(this.font, new TranslationTextComponent("controllable.gui.layout.info", new Object[0]).func_211708_a(TextFormatting.GRAY), x + width / 2, y + 135, width + 190, -1);
        super.render(mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.disableDepthTest();
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            this.drawCenteredString(this.font, I18n.func_135052_a((String)"controllable.gui.layout.press_button", (Object[])new Object[0]), this.width / 2, this.height / 2, -1);
            RenderSystem.enableDepthTest();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<String>();
            components.add(new TranslationTextComponent("controllable.gui.layout.button", new Object[]{new TranslationTextComponent(Buttons.NAMES[button.getButton()], new Object[0]).func_211708_a(TextFormatting.BLUE).func_150254_d()}).func_150254_d());
            if (button.isMissingMapping()) {
                components.add(new TranslationTextComponent("controllable.gui.layout.missing_mapping", new Object[0]).func_211708_a(TextFormatting.RED).func_150254_d());
            } else {
                int remappedButton = button.getButton();
                if (!button.isMissingMapping()) {
                    Map<Integer, Integer> reassignments = this.entry.getReassignments();
                    for (Integer key : reassignments.keySet()) {
                        if (reassignments.get(key) != remappedButton) continue;
                        remappedButton = key;
                        break;
                    }
                }
                components.add(new TranslationTextComponent("controllable.gui.layout.mapped_to", new Object[]{new StringTextComponent(String.valueOf(remappedButton)).func_211708_a(TextFormatting.BLUE)}).func_150254_d());
            }
            components.add(new TranslationTextComponent("controllable.gui.layout.remap", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150254_d());
            this.renderTooltip(components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.isHovered()) {
            components = new ArrayList();
            components.add(new TranslationTextComponent("controllable.gui.layout.warning", new Object[0]).func_211708_a(TextFormatting.RED).func_150254_d());
            components.addAll(this.font.func_78271_c(new TranslationTextComponent("controllable.gui.layout.invalid_layout", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150254_d(), 180));
            this.renderTooltip(components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.isHovered()) {
            this.renderTooltip(new TranslationTextComponent("controllable.gui.layout.thumbsticks", new Object[0]).func_150254_d(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.keyPressed(key, scanCode, mods);
    }

    public boolean onButtonInput(int button) {
        if (this.configureButton != -1) {
            Map<Integer, Integer> reassignments = this.entry.getReassignments();
            if (button != this.configureButton) {
                reassignments.putIfAbsent(this.configureButton, -1);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != this.configureButton) continue;
                    reassignments.put(key, -1);
                }
                reassignments.put(button, this.configureButton);
            } else {
                reassignments.remove(button);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != button) continue;
                    reassignments.put(key, -1);
                }
            }
            this.configureButton = -1;
            return true;
        }
        return false;
    }

    private void updateControllerMapping() {
        Controller controller = Controllable.getController();
        if (controller != null) {
            controller.setMapping(this.entry);
            this.entry.save();
        }
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        if (state && this.onButtonInput(index)) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if ((index = this.remap(index)) == -1) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)0.9f));
        }
    }

    public int remap(int button) {
        return this.entry.remap(button);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public Map<Integer, Integer> getReassignments() {
        return this.entry.getReassignments();
    }

    public Mappings.Entry getEntry() {
        return this.entry;
    }

    private void drawMultiLineCenteredString(FontRenderer font, ITextComponent component, int x, int y, int width, int color) {
        for (String s : font.func_78271_c(component.func_150254_d(), width)) {
            font.func_211126_b(s, (float)((double)x - (double)font.func_78256_a(s) / 2.0), (float)y, color);
            font.getClass();
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

