/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.gui.ControllerEntry;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ControllerList
extends ExtendedList<ControllerEntry> {
    private ControllerManager manager;

    public ControllerList(ControllerManager manager, Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.manager = manager;
        this.reload();
    }

    public void reload() {
        this.clearEntries();
        Map<Integer, String> controllers = this.manager.getControllers();
        controllers.forEach((jid, name) -> this.addEntry((AbstractList.AbstractListEntry)new ControllerEntry(this, (int)jid)));
        this.updateSelected();
    }

    public void updateSelected() {
        Controller controller = Controllable.getController();
        if (controller == null) {
            this.setSelected(null);
            return;
        }
        List entries = this.children();
        for (ControllerEntry entry : entries) {
            if (entry.getJid() != controller.getJid()) continue;
            this.setSelected((AbstractList.AbstractListEntry)entry);
            break;
        }
    }
}

