/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.block;

import com.breakinblocks.plonk.common.registry.RegistryMaterials;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.ItemUtils;
import com.breakinblocks.plonk.common.util.WorldUtils;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlacedItems
extends Block {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockPlacedItems() {
        super((Material)RegistryMaterials.placed_items);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149672_a(SoundType.field_185851_d);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WorldUtils.withTile(source, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().getBoundingBox(pos), () -> field_185505_j);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        WorldUtils.withTile((IBlockAccess)worldIn, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().addCollidingBoxes(pos, entityBox, collidingBoxes));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return WorldUtils.withTile((IBlockAccess)worldIn, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().getSelectedBoundingBoxFromPool(), () -> field_185505_j);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return WorldUtils.withTile((IBlockAccess)worldIn, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().collisionRayTrace(this, (x$0, x$1, x$2, x$3, x$4) -> super.func_180636_a(x$0, x$1, x$2, x$3, x$4), blockState, worldIn, pos, start, end), () -> null);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldId, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldId.field_72995_K) {
            return true;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerIn;
        double blockReachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        float partialTicks = 0.0f;
        Vec3d from = player.func_174824_e(partialTicks);
        Vec3d look = player.func_70676_i(partialTicks);
        Vec3d to = from.func_72441_c(look.field_72450_a * blockReachDistance, look.field_72448_b * blockReachDistance, look.field_72449_c * blockReachDistance);
        if (worldId.func_147447_a(from, to, false, false, true) != null) {
            TilePlacedItems tile = (TilePlacedItems)worldId.func_175625_s(pos);
            Objects.requireNonNull(tile);
            int index = tile.getContentsBoxes().getSelectedId();
            int slot = index <= 0 ? 0 : index - 1;
            ItemStack stack = tile.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (player.func_70093_af()) {
                    tile.rotateSlot(slot);
                } else {
                    ItemUtils.dropItemOnEntity((EntityLivingBase)player, stack);
                    tile.func_70299_a(slot, ItemStack.field_190927_a);
                }
                tile.func_70296_d();
                tile.clean();
            }
            return true;
        }
        return super.func_180639_a(worldId, pos, state, (EntityPlayer)player, hand, facing, hitX, hitY, hitZ);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
        Objects.requireNonNull(tile);
        float yaw = placer.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = Math.round(yaw / 90.0f) % 4;
        rotation = facing == EnumFacing.UP ? (rotation + 2) % 4 : (facing == EnumFacing.DOWN ? 4 - rotation : 0);
        tile.setTileRotation(rotation);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePlacedItems();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WorldUtils.withTile((IBlockAccess)world, pos, TilePlacedItems.class, tile -> {
            int index = tile.getContentsBoxes().getSelectedId();
            int slot = index <= 0 ? 0 : index - 1;
            return tile.func_70301_a(slot);
        }, () -> ItemStack.field_190927_a);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return super.getSoundType(state, world, pos, entity);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

