/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.config;

import com.breakinblocks.plonk.common.util.ItemUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlonkConfig {
    public static Configuration config;
    public static int maxStackSize;
    public static Set<ResourceLocation> unplaceableItems;

    public static int getInventoryStackLimit() {
        return maxStackSize <= 0 ? ItemUtils.getMaxStackSize() : maxStackSize;
    }

    public static boolean canPlace(ItemStack stack) {
        return !unplaceableItems.contains(ItemUtils.getIdentifier(stack));
    }

    private static void sync() {
        maxStackSize = config.getInt("maxStackSize", "general", -1, -1, Integer.MAX_VALUE, "Max stack size per slot (-1 or 0 to use default). Going above 64 needs a mod like StackUp!.");
        unplaceableItems = Arrays.stream(config.getStringList("unplaceableItems", "general", new String[]{"carryon:entity_item", "carryon:tile_item"}, "Items that cannot be placed down, in the format 'mod_id:item_id' e.g. minecraft:carrot")).map(ResourceLocation::new).collect(Collectors.toCollection(LinkedHashSet::new));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void init(File suggestedConfigurationFile) {
        MinecraftForge.EVENT_BUS.register((Object)new Listener());
        config = new Configuration(suggestedConfigurationFile);
        config.load();
        PlonkConfig.sync();
    }

    static {
        maxStackSize = -1;
        unplaceableItems = Collections.emptySet();
    }

    public static class Listener {
        @SubscribeEvent
        public void reloadConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (!event.getModID().equals("plonk")) {
                return;
            }
            PlonkConfig.sync();
        }
    }
}

