/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlaceItem
extends PacketBase<PacketPlaceItem> {
    private BlockPos pos;
    private EnumFacing facing;
    private float hitX;
    private float hitY;
    private float hitZ;
    private int renderType;

    public PacketPlaceItem() {
    }

    public PacketPlaceItem(BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int renderType) {
        this.pos = pos;
        this.facing = facing;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
        this.renderType = renderType;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.facing = EnumFacing.values()[buf.readInt()];
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
        this.renderType = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.facing.ordinal());
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
        buf.writeInt(this.renderType);
    }

    @Override
    public Side getSideBound() {
        return Side.SERVER;
    }

    @Override
    protected void handle(MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer world = player.func_71121_q();
        ItemStack toPlace = new ItemStack((Item)RegistryItems.placed_items, 1);
        ItemStack held = player.func_184614_ca();
        RegistryItems.placed_items.setHeldStack(toPlace, held, this.renderType);
        EntityUtils.setHeldItemSilent((EntityPlayer)player, EnumHand.MAIN_HAND, toPlace);
        if (toPlace.func_179546_a((EntityPlayer)player, (World)world, this.pos, EnumHand.MAIN_HAND, this.facing, this.hitX, this.hitY, this.hitZ) == EnumActionResult.SUCCESS) {
            ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
            EntityUtils.setHeldItemSilent((EntityPlayer)player, EnumHand.MAIN_HAND, newHeld);
        } else {
            EntityUtils.setHeldItemSilent((EntityPlayer)player, EnumHand.MAIN_HAND, held);
        }
    }
}

