/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketRotateTile
extends PacketBase<PacketRotateTile> {
    private BlockPos pos;

    public PacketRotateTile() {
    }

    public PacketRotateTile(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    @Override
    public Side getSideBound() {
        return Side.SERVER;
    }

    @Override
    protected void handle(MessageContext ctx) {
        TileEntity te;
        if (ctx.side == Side.CLIENT) {
            throw new RuntimeException("PacketRotateTile should be server-bound only.");
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer world = player.func_71121_q();
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 2.0;
        if (player.func_174818_b(this.pos) < reach * reach && (te = world.func_175625_s(this.pos)) instanceof TilePlacedItems) {
            ((TilePlacedItems)te).rotateTile();
        }
    }
}

