/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemUtils {
    private static final ItemStack REFERENCE = new ItemStack(Items.field_190931_a);

    @Nullable
    public static EntityItem dropItemOnEntity(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        EntityItem entityItem = new EntityItem(entity.field_70170_p, x, y, z, stack.func_77946_l());
        return entity.field_70170_p.func_72838_d((Entity)entityItem) ? entityItem : null;
    }

    public static boolean areStacksEqualIgnoringSize(ItemStack a, ItemStack b) {
        if (a.func_190926_b()) {
            return b.func_190926_b();
        }
        if (b.func_190926_b()) {
            return false;
        }
        if (!a.func_77969_a(b)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack insertStack(IInventory inv, ItemStack stack) {
        return ItemUtils.insertStackAdv((IInventory)inv, (ItemStack)stack).remainder;
    }

    public static InsertStackResult insertStackAdv(IInventory inv, ItemStack stack) {
        if (stack.func_190926_b()) {
            return new InsertStackResult(stack, new int[0]);
        }
        int stackSizeLimit = Math.min(stack.func_77976_d(), inv.func_70297_j_());
        int size = inv.func_70302_i_();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ItemStack remainder = stack;
        for (int slot = 0; slot < size && !remainder.func_190926_b(); ++slot) {
            int toTransfer;
            ItemStack current;
            if (!inv.func_94041_b(slot, stack) || !(current = inv.func_70301_a(slot)).func_190926_b() && !ItemUtils.areStacksEqualIgnoringSize(current, remainder) || (toTransfer = Math.min(current.func_190916_E() + remainder.func_190916_E(), stackSizeLimit) - current.func_190916_E()) <= 0) continue;
            if (current.func_190926_b()) {
                current = remainder.func_77946_l();
                current.func_190920_e(toTransfer);
            } else {
                current.func_190920_e(current.func_190916_E() + toTransfer);
            }
            if (remainder == stack) {
                remainder = stack.func_77946_l();
            }
            remainder.func_190920_e(remainder.func_190916_E() - toTransfer);
            inv.func_70299_a(slot, current);
            slots.add(slot);
        }
        int[] slotsArray = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            slotsArray[i] = (Integer)slots.get(i);
        }
        return new InsertStackResult(remainder, slotsArray);
    }

    public static int getMaxStackSize() {
        return REFERENCE.func_77976_d();
    }

    @Nullable
    public static ResourceLocation getIdentifier(ItemStack stack) {
        return stack.func_77973_b().getRegistryName();
    }

    public static class InsertStackResult {
        public final ItemStack remainder;
        public final int[] slots;

        public InsertStackResult(ItemStack remainder, int[] slots) {
            this.remainder = remainder;
            this.slots = slots;
        }
    }
}

