/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3d;

public class MatrixUtils {
    public static Matrix4d difference(Matrix4d a, Matrix4d b) {
        Matrix4d aInv = new Matrix4d();
        aInv.invert(a);
        Matrix4d D = new Matrix4d();
        D.mul(aInv, b);
        return D;
    }

    public static class TransformData {
        public final double tx;
        public final double ty;
        public final double tz;
        public final double sx;
        public final double sy;
        public final double sz;
        public final Matrix3d rot;
        public final double pitch;
        public final double yaw;
        public final double roll;

        public TransformData(Matrix4f mat) {
            this(new Matrix4d(mat));
        }

        public TransformData(Matrix4d mat) {
            mat = new Matrix4d(mat);
            this.tx = mat.m30;
            this.ty = mat.m31;
            this.tz = mat.m32;
            this.sx = new Vector3d(mat.m00, mat.m10, mat.m20).length();
            this.sy = new Vector3d(mat.m01, mat.m11, mat.m21).length();
            this.sz = new Vector3d(mat.m02, mat.m12, mat.m22).length();
            this.rot = new Matrix3d(mat.m00 / this.sx, mat.m01 / this.sy, mat.m02 / this.sz, mat.m10 / this.sx, mat.m11 / this.sy, mat.m12 / this.sz, mat.m20 / this.sx, mat.m21 / this.sy, mat.m22 / this.sz);
            this.yaw = Math.toDegrees(Math.atan2(this.rot.m02, this.rot.m22));
            this.pitch = Math.toDegrees(-Math.atan2(this.rot.m12, Math.sqrt(Math.pow(this.rot.m10, 2.0) + Math.pow(this.rot.m11, 2.0))));
            this.roll = Math.toDegrees(Math.atan2(this.rot.m10, this.rot.m11));
        }

        public String toString() {
            return String.format("tx=%.3f", this.tx) + String.format(" ty=%.3f", this.ty) + String.format(" tz=%.3f", this.tz) + String.format(" sx=%.3f", this.sx) + String.format(" sy=%.3f", this.sy) + String.format(" sz=%.3f", this.sz) + String.format(" pitch=%.3f", this.pitch) + String.format(" yaw=%.3f", this.yaw) + String.format(" roll=%.3f", this.roll);
        }
    }
}

