/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class WorldUtils {
    @Nullable
    public static <TILE extends TileEntity> TILE getTileEntity(IBlockAccess world, BlockPos pos, Class<TILE> clazz) {
        TileEntity tile = world.func_175625_s(pos);
        if (clazz.isInstance(tile)) {
            return (TILE)((TileEntity)clazz.cast(tile));
        }
        return null;
    }

    public static <TILE extends TileEntity> void withTile(IBlockAccess world, BlockPos pos, Class<TILE> clazz, Consumer<TILE> consumer) {
        TILE tile = WorldUtils.getTileEntity(world, pos, clazz);
        if (tile != null) {
            consumer.accept(tile);
        }
    }

    public static <TILE extends TileEntity, RETURN> RETURN withTile(IBlockAccess world, BlockPos pos, Class<TILE> clazz, Function<TILE, RETURN> func, Supplier<RETURN> def) {
        TILE tile = WorldUtils.getTileEntity(world, pos, clazz);
        if (tile != null) {
            return func.apply(tile);
        }
        return def.get();
    }
}

