/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block;

import cubicoder.well.block.entity.WellBlockEntity;
import cubicoder.well.config.WellConfig;
import cubicoder.well.sound.ModSounds;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WellBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.func_177716_a((String)"upside_down");
    public static final VoxelShape SHAPE_BASE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    public static final VoxelShape SHAPE_INNER_SUPPORT = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.5, (double)0.0, (double)1.0, (double)8.5, (double)15.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)15.0, (double)15.0), Block.func_208617_a((double)7.5, (double)7.0, (double)2.0, (double)8.5, (double)8.0, (double)14.0), Block.func_208617_a((double)5.0, (double)4.5, (double)4.5, (double)11.0, (double)10.5, (double)11.5)});
    public static final VoxelShape SHAPE_ROOF = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.5, (double)12.5, (double)0.0, (double)10.5, (double)15.707, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.75, (double)10.5, (double)0.0, (double)5.5, (double)13.75, (double)16.0), Block.func_208617_a((double)10.5, (double)10.5, (double)0.0, (double)13.25, (double)13.75, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)2.75, (double)11.25, (double)16.0), Block.func_208617_a((double)13.25, (double)8.0, (double)0.0, (double)16.0, (double)11.25, (double)16.0), SHAPE_INNER_SUPPORT});

    public WellBlock(MaterialColor mapColor) {
        this(Material.field_151576_e, mapColor);
    }

    public WellBlock(Material material, MaterialColor mapColor) {
        this(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)mapColor).func_200948_a(3.0f, 1.5f).harvestLevel(0).harvestTool(ToolType.PICKAXE).func_235861_h_());
    }

    public WellBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WellBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS, HALF, UPSIDE_DOWN});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction.Axis axis;
        World level = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction.Axis axis2 = axis = context.func_195999_j().func_213453_ef() ? context.func_195992_f().func_176746_e().func_176740_k() : context.func_195992_f().func_176740_k();
        if (pos.func_177956_o() < level.func_217301_I() - 1 && level.func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)axis)).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false));
        }
        if (pos.func_177956_o() >= 0 && level.func_180495_p(pos.func_177977_b()).func_196953_a(context)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)axis)).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos currentPos, BlockPos neighborPos) {
        Direction flippedDir2;
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        Direction flippedDir1 = (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? Direction.DOWN : Direction.UP;
        Direction direction2 = flippedDir2 = (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? Direction.UP : Direction.DOWN;
        if ((direction.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == flippedDir1) || neighborState.func_203425_a((Block)this) && neighborState.func_177229_b(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != flippedDir2 || state.func_196955_c((IWorldReader)level, currentPos))) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity be;
        level.func_175656_a(pos.func_177981_b((Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? -1 : 1), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
        if (((Boolean)WellConfig.onlyOnePerChunk.get()).booleanValue() && placer instanceof ServerPlayerEntity && (be = level.func_175625_s(pos)) instanceof WellBlockEntity && ((WellBlockEntity)be).nearbyWells > 1) {
            String message = (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? "warn.well.onePerChunkFlipped" : "warn.well.onePerChunk";
            ((ServerPlayerEntity)placer).func_146105_b((ITextComponent)new TranslationTextComponent(message), true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return super.func_196260_a(state, level, pos);
        }
        BlockState base = level.func_180495_p(pos.func_177979_c((Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? -1 : 1));
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, level, pos);
        }
        return base.func_203425_a((Block)this) && base.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public void func_176208_a(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos otherPos;
        BlockState otherState;
        if (!level.field_72995_K && state.func_177229_b(HALF) == DoubleBlockHalf.UPPER && (otherState = level.func_180495_p(otherPos = pos.func_177979_c((Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? -1 : 1))).func_203425_a((Block)this) && otherState.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            if (player.func_184812_l_()) {
                level.func_225521_a_(otherPos, false, (Entity)player);
            } else {
                level.func_225521_a_(otherPos, this.canHarvestBlock(state, (IBlockReader)level, pos, player), (Entity)player);
            }
        }
        super.func_176208_a(level, pos, state, player);
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity be = level.func_175625_s(pos);
            if (be instanceof WellBlockEntity) {
                ((WellBlockEntity)be).countNearbyWells(e -> --e.nearbyWells);
            }
            super.func_196243_a(state, level, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return ActionResultType.PASS;
        }
        if (!player.func_184586_b(hand).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.PASS;
        }
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity be = level.func_175625_s(pos);
        if (be instanceof WellBlockEntity) {
            WellBlockEntity well = (WellBlockEntity)be;
            boolean delayFlag = true;
            boolean fillingItem = FluidUtil.tryFillContainer((ItemStack)player.func_184586_b((Hand)hand), (IFluidHandler)well.getTank(), (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)false).success;
            if (fillingItem && well.delayUntilNextBucket > 0) {
                delayFlag = false;
            }
            if (delayFlag && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)level, (BlockPos)pos, (Direction)hit.func_216354_b())) {
                if (((Boolean)WellConfig.playSound.get()).booleanValue() && fillingItem) {
                    level.func_184133_a(null, pos.func_177984_a(), (SoundEvent)ModSounds.CRANK.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
                    well.delayUntilNextBucket = 32;
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public int getLightValue(BlockState state, IBlockReader level, BlockPos pos) {
        int baseFluidLight;
        FluidStack fluid;
        TileEntity be;
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && (be = level.func_175625_s(pos)) instanceof WellBlockEntity && (fluid = ((WellBlockEntity)be).getTank().getFluid()) != null && !fluid.isEmpty() && (baseFluidLight = fluid.getFluid().getAttributes().getLuminosity()) > 0) {
            return MathHelper.func_76125_a((int)((int)((double)(baseFluidLight * fluid.getAmount() / (Integer)WellConfig.tankCapacity.get()) + 0.5)), (int)1, (int)15);
        }
        return 0;
    }

    public void func_196262_a(BlockState state, World level, BlockPos pos, Entity entity) {
        WellBlockEntity well;
        FluidStack fluid;
        TileEntity be;
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && (be = level.func_175625_s(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.func_177229_b((Property)UPSIDE_DOWN);
            FluidState fluidState = fluid.getFluid().getAttributes().getStateForPlacement((IBlockDisplayReader)level, pos, fluid);
            Material fluidMaterial = fluid.getFluid().getAttributes().getBlock((IBlockDisplayReader)level, pos, fluidState).func_185904_a();
            if (!upsideDown) {
                if (entity.func_226278_cu_() < (double)pos.func_177956_o() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                    if (fluidMaterial == Material.field_151587_i && !entity.func_230279_az_()) {
                        entity.func_70015_d(15);
                        entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                    }
                    if (fluidMaterial == Material.field_151586_h && !level.field_72995_K && entity.func_70027_ad()) {
                        entity.func_70066_B();
                    }
                }
            } else if (entity.func_226278_cu_() > (double)pos.func_177956_o() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                // empty if block
            }
        }
    }

    public void func_180655_c(BlockState state, World level, BlockPos pos, Random random) {
        WellBlockEntity well;
        FluidStack fluid;
        TileEntity be;
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && (be = level.func_175625_s(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.func_177229_b((Property)UPSIDE_DOWN);
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            FluidState fluidState = fluid.getFluid().func_207188_f();
            fluidState.func_206881_a(level, pos, random);
            if (fluid.getFluid() == Fluids.field_204547_b) {
                double z;
                double y;
                double x;
                if (random.nextInt(100) == 0) {
                    x = (double)pos.func_177958_n() + random.nextDouble();
                    y = (double)pos.func_177956_o() + (double)height;
                    z = (double)pos.func_177952_p() + random.nextDouble();
                    level.func_195594_a((IParticleData)ParticleTypes.field_197595_F, x, y, z, 0.0, 0.0, 0.0);
                    level.func_184134_a(x, y, z, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
                if (random.nextInt(200) == 0) {
                    x = (double)pos.func_177958_n() + 0.5;
                    y = (double)pos.func_177956_o() + (double)(height / 2.0f);
                    z = (double)pos.func_177952_p() + 0.5;
                    level.func_184134_a(x, y, z, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
        }
    }

    public SoundType getSoundType(BlockState state, IWorldReader level, BlockPos pos, Entity entity) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? this.field_149762_H : Blocks.field_196584_bK.getSoundType(state, level, pos, entity);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_196266_a(BlockState state, IBlockReader level, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.func_177229_b(AXIS) == Direction.Axis.X) {
            return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_ROOF)) : WellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader level, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.func_177229_b(AXIS) == Direction.Axis.X) {
            return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_INNER_SUPPORT) : SHAPE_INNER_SUPPORT;
        }
        return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT)) : WellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader level, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return VoxelShapes.func_197868_b();
        }
        if (state.func_177229_b(AXIS) == Direction.Axis.X) {
            return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_ROOF)) : WellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public static VoxelShape flipShapeXZ(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(minZ, minY, minX, maxZ, maxY, maxX)));
        });
        return buffer[1];
    }

    public static VoxelShape flipShapeUpsideDown(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(minX, 1.0 - maxY, minZ, maxX, 1.0 - minY, maxZ)));
        });
        return buffer[1];
    }

    public static float getFluidRenderHeight(int amount, int capacity, boolean upsideDown) {
        float height = (float)amount * 14.0f / (float)(16 * capacity) + 0.125f;
        return upsideDown ? 1.0f - height : height;
    }
}

