/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block.entity;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.WellBlock;
import cubicoder.well.config.WellConfig;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WellBlockEntity
extends TileFluidHandler
implements ITickableTileEntity {
    public int fillTick = 0;
    public int nearbyWells = 1;
    public int delayUntilNextBucket = 0;
    public boolean initialized;

    public WellBlockEntity() {
        super((TileEntityType)ModBlocks.WELL_BE.get());
        this.tank = new WellFluidTank(this, (Integer)WellConfig.tankCapacity.get());
    }

    public void func_73660_a() {
        if (this.delayUntilNextBucket > 0) {
            --this.delayUntilNextBucket;
        }
        if (this.fillTick > 0) {
            --this.fillTick;
            this.func_70296_d();
        }
        if (this.fillTick <= 0 && WellConfig.canGenerateFluid(this.nearbyWells)) {
            FluidStack fluidToFill = this.getFluidToFill();
            int result = 0;
            if (fluidToFill != null) {
                result = this.tank.fill(fluidToFill, IFluidHandler.FluidAction.EXECUTE);
            }
            if (result > 0) {
                this.initFillTick();
                this.func_70296_d();
            }
        }
    }

    public void onLoad() {
        if (!this.initialized) {
            this.initialized = true;
            if (!this.field_145850_b.field_72995_K) {
                this.initFillTick();
                this.countNearbyWells(be -> {
                    ++be.nearbyWells;
                    ++this.nearbyWells;
                });
            }
        }
        if (((WellFluidTank)this.tank).updateLight(this.tank.getFluid())) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    protected FluidStack getFluidToFill() {
        return WellConfig.getFillFluid(this.field_145850_b.func_226691_t_(this.func_174877_v()), this.field_145850_b, this.func_174877_v(), this.isUpsideDown(), this.nearbyWells);
    }

    protected void initFillTick() {
        this.fillTick = WellConfig.getFillDelay(this.field_145850_b.func_226691_t_(this.func_174877_v()), this.field_145850_b, this.field_145850_b.field_73012_v, this.isUpsideDown());
    }

    public void countNearbyWells(Consumer<WellBlockEntity> updateScript) {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_203066_o().forEach(otherPos -> {
            TileEntity be;
            if (!otherPos.equals((Object)this.func_174877_v()) && (be = this.field_145850_b.func_175625_s(otherPos)) instanceof WellBlockEntity && ((WellBlockEntity)be).isUpsideDown() == this.isUpsideDown()) {
                updateScript.accept((WellBlockEntity)be);
            }
        });
    }

    public boolean isUpsideDown() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)WellBlock.UPSIDE_DOWN);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.fillTick = tag.func_74762_e("FillTick");
        this.nearbyWells = Math.max(1, tag.func_74762_e("NearbyWells"));
        this.initialized = tag.func_74767_n("Initialized");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("FillTick", this.fillTick);
        tag.func_74768_a("NearbyWells", this.nearbyWells);
        tag.func_74757_a("Initialized", this.initialized);
        return tag;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        boolean wasFull;
        FluidStack oldFluid = this.tank.getFluid();
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
        FluidStack newFluid = this.tank.getFluid();
        boolean wasEmpty = newFluid != null && oldFluid == null;
        boolean bl = wasFull = newFluid == null && oldFluid != null;
        if (wasEmpty || wasFull || newFluid != null && newFluid.getAmount() != oldFluid.getAmount()) {
            if (newFluid != null) {
                ((WellFluidTank)this.tank).updateLight(newFluid);
            } else {
                ((WellFluidTank)this.tank).updateLight(oldFluid);
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public static class WellFluidTank
    extends FluidTank {
        private WellBlockEntity well;

        public WellFluidTank(WellBlockEntity well, int capacity) {
            super(capacity);
            this.well = well;
            this.setValidator(fluid -> {
                boolean isLighterThanAir = fluid.getFluid().getAttributes().isLighterThanAir();
                if (this.well.isUpsideDown()) {
                    return isLighterThanAir;
                }
                if (isLighterThanAir) {
                    return false;
                }
                return !this.well.func_145831_w().func_230315_m_().func_236040_e_() || !fluid.getFluid().getAttributes().doesVaporize((IBlockDisplayReader)this.well.func_145831_w(), this.well.func_174877_v(), fluid);
            });
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int fill;
            int n = fill = this.well.getFluidToFill().getFluid() == resource.getFluid() ? super.fill(resource, action) : 0;
            if (action.execute() && fill > 0) {
                BlockState state = this.well.func_195044_w();
                this.well.func_145831_w().func_184138_a(this.well.func_174877_v(), state, state, 3);
                this.updateLight(resource);
            }
            return fill;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack resource = super.drain(maxDrain, action);
            if (resource != null && action.execute()) {
                BlockState state = this.well.func_195044_w();
                this.well.func_145831_w().func_184138_a(this.well.func_174877_v(), state, state, 3);
                this.updateLight(resource);
            }
            return resource;
        }

        protected boolean updateLight(FluidStack resource) {
            if (resource != null && resource.getFluid().getAttributes().getLuminosity() > 0) {
                this.well.func_145831_w().func_225524_e_().func_215568_a(this.well.func_174877_v());
                return true;
            }
            return false;
        }
    }
}

