/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import cubicoder.well.block.WellBlock;
import cubicoder.well.block.entity.WellBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;

public class WellRenderer
extends TileEntityRenderer<WellBlockEntity> {
    public WellRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(WellBlockEntity well, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        FluidStack fluid = well.getTank().getFluid();
        if (!fluid.isEmpty()) {
            int amount = fluid.getAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = well.isUpsideDown();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getStillTexture(fluid));
            int color = fluid.getFluid().getAttributes().getColor((IBlockDisplayReader)well.func_145831_w(), well.func_174877_v());
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float corner = 0.1875f;
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            float minU = sprite.func_94214_a(3.0);
            float maxU = sprite.func_94214_a(13.0);
            float minV = sprite.func_94207_b(3.0);
            float maxV = sprite.func_94207_b(13.0);
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228645_f_());
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            if (upsideDown) {
                builder.func_227888_a_(matrix, 1.0f - corner, height, corner).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, 1.0f - corner, height, 1.0f - corner).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, corner, height, 1.0f - corner).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, corner, height, corner).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_227886_a_(combinedLight).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            } else {
                builder.func_227888_a_(matrix, corner, height, corner).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, corner, height, 1.0f - corner).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, 1.0f - corner, height, 1.0f - corner).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
                builder.func_227888_a_(matrix, 1.0f - corner, height, corner).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227886_a_(combinedLight).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            }
        }
    }
}

