/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cubicoder.well.config.WellData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class WellConfig {
    public static final ForgeConfigSpec CLIENT_CONFIG = WellConfig.clientConfig(new ForgeConfigSpec.Builder());
    public static final ForgeConfigSpec SERVER_CONFIG = WellConfig.serverConfig(new ForgeConfigSpec.Builder());
    public static ForgeConfigSpec.IntValue tankCapacity;
    public static ForgeConfigSpec.BooleanValue onlyOnePerChunk;
    public static ForgeConfigSpec.BooleanValue playSound;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> dataList;
    private static final List<WellData> regularWellDataList;
    private static final List<WellData> upsideWellDataList;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG);
    }

    private static ForgeConfigSpec clientConfig(ForgeConfigSpec.Builder builder) {
        playSound = builder.comment("Play the well cranking sound when someone takes fluid from a well.").translation("config.well.playSound").define("playSound", true);
        return builder.build();
    }

    private static ForgeConfigSpec serverConfig(ForgeConfigSpec.Builder builder) {
        tankCapacity = builder.comment("How many millibuckets of a fluid can wells hold? Set to 0 to disable.").translation("config.well.tankCapacity").worldRestart().defineInRange("tankCapacity", 100000, 0, Integer.MAX_VALUE);
        onlyOnePerChunk = builder.comment("When set to true, all wells in the chunk will stop working while there's more than 1.").translation("config.well.onlyOnePerChunk").define("onlyOnePerChunk", false);
        dataList = builder.comment("Handle what fluids wells collect based on biome, and how much").translation("config.well.data").defineListAllowEmpty(Collections.singletonList("dataList"), () -> Collections.singletonList("{}"), WellConfig::validateData);
        return builder.build();
    }

    public static boolean validateData(Object entry) {
        if (!(entry instanceof String)) {
            return false;
        }
        try {
            JsonToNBT.func_180713_a((String)((String)entry));
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static void initData(String entry) {
        try {
            CompoundNBT data = JsonToNBT.func_180713_a((String)entry);
            if (data.func_150297_b("Fluid", 10)) {
                int minToFill;
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)data.func_74775_l("Fluid"));
                if (fluid == null) {
                    return;
                }
                boolean isUpsideDown = fluid.getFluid().getAttributes().isLighterThanAir();
                int n = data.func_150297_b("MinTicks", 3) ? Math.abs(data.func_74762_e("MinTicks")) : (minToFill = (isUpsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT).minToFill);
                int maxToFill = data.func_150297_b("MaxTicks", 3) ? Math.abs(data.func_74762_e("MaxTicks")) : (isUpsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT).maxToFill;
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                data.func_150295_c("Biomes", 8).forEach(biomeNbt -> biomes.add((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeNbt.func_150285_a_()))));
                ArrayList<BiomeDictionary.Type> biomeTags = new ArrayList<BiomeDictionary.Type>();
                data.func_150295_c("BiomeTags", 8).forEach(biomeTagNbt -> biomeTags.add(BiomeDictionary.Type.getType((String)biomeTagNbt.func_150285_a_(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0])));
                if (biomes.isEmpty() && biomeTags.isEmpty()) {
                    WellData wellData = new WellData(fluid, minToFill, maxToFill);
                    if (isUpsideDown) {
                        WellData.UPSIDE_DEFAULT.fluid = wellData.fluid;
                        WellData.UPSIDE_DEFAULT.minToFill = wellData.minToFill;
                        WellData.UPSIDE_DEFAULT.maxToFill = wellData.maxToFill;
                    } else {
                        WellData.REGULAR_DEFAULT.fluid = wellData.fluid;
                        WellData.REGULAR_DEFAULT.minToFill = wellData.minToFill;
                        WellData.REGULAR_DEFAULT.maxToFill = wellData.maxToFill;
                    }
                } else {
                    WellData wellData = new WellData(fluid, minToFill, maxToFill, biomes, biomeTags);
                    if (isUpsideDown) {
                        upsideWellDataList.add(wellData);
                    } else {
                        regularWellDataList.add(wellData);
                    }
                }
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static boolean canGenerateFluid(int nearbyWells) {
        return (Boolean)onlyOnePerChunk.get() == false || nearbyWells == 1;
    }

    public static FluidStack getFillFluid(Biome biome, World level, BlockPos pos, boolean upsideDown, int nearbyWells) {
        WellData data = WellConfig.getWellDataForBiome(biome, level, upsideDown);
        FluidStack fluid = data.fluid.copy();
        return fluid;
    }

    public static int getFillDelay(Biome biome, World level, Random random, boolean upsideDown) {
        WellData data = WellConfig.getWellDataForBiome(biome, level, upsideDown);
        return MathHelper.func_76136_a((Random)random, (int)data.minToFill, (int)data.maxToFill);
    }

    private static WellData getWellDataForBiome(Biome biome, World level, boolean upsideDown) {
        for (WellData wellData : upsideDown ? upsideWellDataList : regularWellDataList) {
            if (!wellData.hasBiome(biome, level)) continue;
            return wellData;
        }
        return upsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT;
    }

    public static void configChanged(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            WellData.REGULAR_DEFAULT.resetToDefault();
            WellData.UPSIDE_DEFAULT.resetToDefault();
            regularWellDataList.clear();
            upsideWellDataList.clear();
            ((List)dataList.get()).forEach(entry -> WellConfig.initData(entry));
        }
    }

    static {
        regularWellDataList = new ArrayList<WellData>();
        upsideWellDataList = new ArrayList<WellData>();
    }
}

