/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidStack;

public class WellData {
    public static final WellData REGULAR_DEFAULT = new WellData(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 160, 200);
    public static final WellData UPSIDE_DEFAULT = new WellData(new FluidStack((Fluid)Fluids.field_204546_a, 1000), 160, 200);
    public FluidStack fluid;
    public int minToFill;
    public int maxToFill;
    public List<Biome> biomes;
    public List<BiomeDictionary.Type> biomeTags;

    public WellData(FluidStack fluid, int minToFill, int maxToFill, List<Biome> biomes, List<BiomeDictionary.Type> biomeTags) {
        this.fluid = fluid;
        this.minToFill = minToFill;
        this.maxToFill = maxToFill;
        this.biomes = biomes;
        this.biomeTags = biomeTags;
    }

    public WellData(FluidStack fluid, int minToFill, int maxToFill) {
        this.fluid = fluid;
        this.minToFill = minToFill;
        this.maxToFill = maxToFill;
        this.biomes = new ArrayList<Biome>();
        this.biomeTags = new ArrayList<BiomeDictionary.Type>();
    }

    public boolean hasBiome(Biome biome, World level) {
        for (Biome b : this.biomes) {
            if (!biome.getRegistryName().equals((Object)b.getRegistryName())) continue;
            return true;
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
        for (BiomeDictionary.Type c : this.biomeTags) {
            if (!BiomeDictionary.getBiomes((BiomeDictionary.Type)c).contains(biomeKey)) continue;
            return true;
        }
        return false;
    }

    public void resetToDefault() {
        this.fluid = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        this.minToFill = 160;
        this.maxToFill = 200;
    }
}

