/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ItemRenderingRegistry {
    private static List<ItemRenderInfo> guiRenders = new ArrayList<ItemRenderInfo>();

    public static ItemRenderInfo addItemRenderer(Item item) {
        ItemRenderInfo ir = new ItemRenderInfo(item);
        guiRenders.add(ir);
        return ir;
    }

    public static List<ItemRenderInfo> getGuiRenders() {
        return guiRenders;
    }

    public static class ItemRenderInfo {
        private Map<ItemCameraTransforms.TransformType, ItemModelMatch> transforms = new HashMap<ItemCameraTransforms.TransformType, ItemModelMatch>();
        private ResourceLocation defaultModelLocation;
        private Item item;

        public ItemRenderInfo(Item i) {
            this.item = i;
            ResourceLocation rlPath = i.getRegistryName();
            this.defaultModelLocation = new ModelResourceLocation(rlPath, "inventory");
        }

        public void addTransformType(String s, ItemCameraTransforms.TransformType type) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(this.item.getRegistryName() + "_" + s, "inventory"));
            this.transforms.put(type, new ItemModelMatch(this, s, type));
        }

        public Map<ItemCameraTransforms.TransformType, ItemModelMatch> getTransforms() {
            return this.transforms;
        }

        public Item getItem() {
            return this.item;
        }

        public ResourceLocation getDefaultModelLocation() {
            return this.defaultModelLocation;
        }

        public static class ItemModelMatch {
            private ItemCameraTransforms.TransformType type;
            private ResourceLocation modelLocation;
            private IBakedModel model;

            public ItemModelMatch(ItemRenderInfo iri, String s, ItemCameraTransforms.TransformType type) {
                this.modelLocation = new ModelResourceLocation(iri.getItem().getRegistryName() + "_" + s, "inventory");
                this.type = type;
            }

            public ResourceLocation getModelLocation() {
                return this.modelLocation;
            }

            public ItemCameraTransforms.TransformType getType() {
                return this.type;
            }

            public void setModel(IBakedModel model) {
                this.model = model;
            }

            public IBakedModel getModel() {
                return this.model;
            }
        }
    }
}

