/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.block.tiles;

import com.swdteam.wotwmod.common.block.base.StandardModelBlock;
import com.swdteam.wotwmod.common.tilentity.BaseTileEntity;
import com.swdteam.wotwmod.common.utils.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BackpackBlock
extends StandardModelBlock
implements IShearable {
    protected static VoxelShape SHAPE_A = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public BackpackBlock(Material material, float hardness, float resistance, int harvestLevel, SoundType sound) {
        super(material, hardness, resistance, harvestLevel, sound);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (worldIn.func_180495_p(pos.func_177977_b()) == Blocks.field_196658_i.func_176223_P() || worldIn.func_180495_p(pos.func_177977_b()) == Blocks.field_150348_b.func_176223_P() || worldIn.func_180495_p(pos.func_177977_b()) == Blocks.field_150354_m.func_176223_P()) && MathUtils.getRANDOM().nextInt(4) == 1;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        return Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            Direction d = BackpackBlock.getFacingFromEntity(pos, placer).func_176734_d();
            if (d == Direction.DOWN) {
                d = Direction.NORTH;
            }
            if (d == Direction.UP) {
                d = Direction.UP;
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)d));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BaseTileEntity) {
                // empty if block
            }
        }
    }

    public void func_230263_a_(SoundCategory category) {
    }

    public boolean func_230262_K__() {
        return false;
    }
}

