/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.block.tiles;

import com.swdteam.wotwmod.common.block.IBlockTooltip;
import com.swdteam.wotwmod.common.init.WOTWTiles;
import com.swdteam.wotwmod.common.tilentity.BaseTileEntity;
import com.swdteam.wotwmod.common.tilentity.decoration.FlagTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class FlagBlock
extends HorizontalBlock
implements IBlockTooltip {
    public static final VoxelShape SHAPE_A = VoxelShapes.func_197873_a((double)0.296875, (double)0.0, (double)0.296875, (double)0.69, (double)2.0, (double)0.69);
    TextComponent tooltipString;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public FlagBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(4.0f, 4.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_200942_a().func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.tooltipString = new StringTextComponent("Flag");
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return super.func_176194_O();
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)WOTWTiles.FLAG.get()).func_200968_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        return Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer != null) {
            Direction d = FlagBlock.getFacingFromEntity(pos, placer).func_176734_d();
            if (d == Direction.DOWN) {
                d = Direction.NORTH;
            }
            if (d == Direction.UP) {
                d = Direction.UP;
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)d));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BaseTileEntity) {
                ((BaseTileEntity)te).rotation = d.func_185119_l();
                te.getTileData().func_74776_a("rotation", d.func_185119_l());
            }
        }
        if (stack.func_82837_s()) {
            FlagTileEntity flag = (FlagTileEntity)worldIn.func_175625_s(pos);
            flag.getTileData().func_74778_a("name", stack.func_200301_q().getString());
            flag.sendUpdates();
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public ITextComponent getName(BlockState state, BlockPos pos, Vector3d hitVec) {
        return this.tooltipString;
    }
}

