/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.block.tiles;

import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWTiles;
import com.swdteam.wotwmod.common.item.TokenItem;
import com.swdteam.wotwmod.common.tilentity.heirlooms.SlotMachineTileEntity;
import com.swdteam.wotwmod.common.utils.MathUtils;
import com.swdteam.wotwmod.common.utils.WOTWRegistries;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SlotMachineBlock
extends HorizontalBlock {
    protected static VoxelShape SHAPE_A = Block.func_208617_a((double)0.0, (double)1.0, (double)-4.0, (double)16.0, (double)24.0, (double)18.0);
    protected static VoxelShape SHAPE_B = Block.func_208617_a((double)0.0, (double)1.0, (double)-4.0, (double)16.0, (double)24.0, (double)18.0);

    public SlotMachineBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).func_200948_a(10.0f, 3600000.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((Property)field_185512_D) == Direction.EAST || state.func_177229_b((Property)field_185512_D) == Direction.WEST) {
            return SHAPE_A;
        }
        return SHAPE_A;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((Property)field_185512_D) == Direction.EAST || state.func_177229_b((Property)field_185512_D) == Direction.WEST) {
            return SHAPE_A;
        }
        return SHAPE_A;
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return super.func_176194_O();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)WOTWTiles.SLOT_MACHINE.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof SlotMachineTileEntity) {
            ItemStack stackIn = player.func_184586_b(handIn);
            SlotMachineTileEntity slots = (SlotMachineTileEntity)te;
            System.out.println(slots.getWantedStack());
            if (stackIn.func_77973_b().equals(Item.func_150899_d((int)slots.getWantedStack())) && stackIn.func_190916_E() >= slots.getWantedAmount() && slots.getWantedStack() != 0) {
                stackIn.func_190918_g(slots.getWantedAmount());
                int score = 0;
                if (stackIn.func_77973_b() instanceof TokenItem) {
                    TokenItem token = (TokenItem)stackIn.func_77973_b();
                    score = slots.getWantedAmount() * token.getTier() + 3 + MathUtils.randomInt(8, 16);
                    if (!worldIn.field_72995_K) {
                        player.func_145747_a((ITextComponent)new StringTextComponent("Bounty Complete! You Scored " + score + " points!"), player.func_110124_au());
                    }
                }
                worldIn.func_184133_a(null, pos, (SoundEvent)WOTWSounds.SOUND_SLOTS_REWARD.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                ItemStack stck = new ItemStack((IItemProvider)WOTWRegistries.workOutPrise(score));
                ItemEntity ent = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), stck);
                player.func_145747_a((ITextComponent)new StringTextComponent("You have earned a " + stck.func_200301_q().getString()), player.func_110124_au());
                ent.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_217376_c((Entity)ent);
                slots.newMission();
                slots.func_70296_d();
            }
            if (!worldIn.field_72995_K) {
                if (slots.getWantedStack() != 0 && player.func_184586_b(handIn).func_190926_b()) {
                    worldIn.func_184133_a(null, pos, (SoundEvent)WOTWSounds.SOUND_SLOTS_REQUEST.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    if (!worldIn.field_72995_K) {
                        ItemStack stck = new ItemStack((IItemProvider)Item.func_150899_d((int)slots.getWantedStack()));
                        player.func_145747_a((ITextComponent)new StringTextComponent("I still want you to bring me " + slots.getWantedAmount() + " " + stck.func_200301_q().getString()), player.func_110124_au());
                    }
                    slots.func_70296_d();
                }
                if (slots.getWantedStack() == 0) {
                    slots.newMission();
                    worldIn.func_184133_a(null, pos, (SoundEvent)WOTWSounds.SOUND_SLOTS_REQUEST.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    ItemStack stck = new ItemStack((IItemProvider)Item.func_150899_d((int)slots.getWantedStack()));
                    if (!worldIn.field_72995_K) {
                        player.func_145747_a((ITextComponent)new StringTextComponent("I'd like you to bring me " + slots.getWantedAmount() + " " + stck.func_200301_q().getString()), player.func_110124_au());
                    }
                    slots.func_70296_d();
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return super.func_180641_l(blockState, worldIn, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
        super.func_206840_a(builder);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }
}

