/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.human;

import com.swdteam.wotwmod.common.entity.human.LooterEntity;
import com.swdteam.wotwmod.common.entity.martian.BombardingMachineEntity;
import com.swdteam.wotwmod.common.entity.martian.FightingMachineEntity;
import com.swdteam.wotwmod.common.entity.projectile.MolotovEntity;
import com.swdteam.wotwmod.common.init.WOTWEntities;
import com.swdteam.wotwmod.common.init.WOTWItems;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWSpawners;
import com.swdteam.wotwmod.common.utils.EntityUtils;
import com.swdteam.wotwmod.common.utils.MathUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class LooterCaptainEntity
extends MonsterEntity
implements IRangedAttackMob {
    public static final DataParameter<Boolean> CHANTING = EntityDataManager.func_187226_a(LooterCaptainEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    int armTime = 0;
    Goal meeleGoal;

    public LooterCaptainEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.22f).func_233815_a_(Attributes.field_233818_a_, 350.0).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.meeleGoal = new MeleeAttackGoal((CreatureEntity)this, 0.4, true);
        this.field_70714_bg.func_75776_a(1, this.meeleGoal);
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, FightingMachineEntity.class, 20.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, BombardingMachineEntity.class, 20.0f, 1.0, 1.2));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("chanting", ((Boolean)this.func_184212_Q().func_187225_a(CHANTING)).booleanValue());
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b("chanting")) {
            this.func_184212_Q().func_187227_b(CHANTING, (Object)compound.func_74767_n("chanting"));
        } else {
            this.func_184212_Q().func_187227_b(CHANTING, (Object)false);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CHANTING, (Object)false);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)WOTWSpawners.LOOTER_SPAWNER.get());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity playerEntity;
            ItemStack stack;
            if (this.field_70146_Z.nextInt(30) == 1) {
                this.makeLooters(3);
            }
            if ((stack = (playerEntity = (PlayerEntity)entityIn).func_184614_ca()) != null && (int)MathUtils.randomDouble(1.0, 16.0) == 4) {
                int lastDMG = stack.func_77952_i();
                if (!stack.func_77973_b().equals(WOTWItems.DIARY.get()) && !stack.func_77948_v()) {
                    ItemStack dropStack = new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E());
                    dropStack.func_196085_b(stack.func_77952_i());
                    playerEntity.func_146097_a(dropStack, true, false);
                    stack.func_190920_e(0);
                }
            }
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (!EntityUtils.canSpawnAtLightLevelCheck((LivingEntity)this, spawnReasonIn, this.field_70170_p)) {
            this.func_70106_y();
            return false;
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() == 0) {
            this.func_70106_y();
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151079_bi));
        this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)Items.field_151040_l));
    }

    protected boolean teleportRandomly() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public void func_70030_z() {
        if (this.func_70090_H()) {
            this.teleportRandomly();
        }
        super.func_70030_z();
    }

    public void makeLooters(int num) {
        for (int i = 0; i < num; ++i) {
            this.func_184185_a((SoundEvent)WOTWSounds.SOUND_ENTITY_CAPTAIN_HORN.get(), 0.4f, MathUtils.randomFloat(0.5f, 1.0f));
            LooterEntity looter = (LooterEntity)((EntityType)WOTWEntities.ENTITY_LOOTER.get()).func_200721_a(this.field_70170_p);
            looter.func_70634_a(this.func_226282_d_(2.0), this.func_226278_cu_() + 2.0, this.func_226287_g_(2.0));
            looter.func_195064_c(new EffectInstance(Effects.field_76424_c, 200, 2));
            this.field_70170_p.func_217376_c((Entity)looter);
            if (this.field_70170_p.func_180495_p(looter.func_233580_cy_()).func_185904_a() == Material.field_151579_a) continue;
            looter.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70146_Z.nextInt(4) == 1) {
            this.teleportRandomly();
        }
        if (this.field_70146_Z.nextInt(4) == 1) {
            this.func_184212_Q().func_187227_b(CHANTING, (Object)true);
            this.makeLooters(3);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        if (!target.func_70089_S()) {
            return;
        }
        d0 = target.func_226277_ct_() - this.func_226277_ct_();
        d1 = target.func_226283_e_(0.3333333333333333) - this.func_226278_cu_() - (double)this.func_70047_e();
        d2 = target.func_226281_cx_() - this.func_226281_cx_();
        if (this.field_70170_p.field_73012_v.nextInt(5) == 2) {
            this.func_184185_a((SoundEvent)WOTWSounds.SOUND_ENTITY_MARTIAN_RAY.get(), 1.0f, 1.0f);
        }
        MolotovEntity molotov = new MolotovEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        molotov.func_213884_b(new ItemStack((IItemProvider)WOTWItems.MOLOTOV.get()));
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        molotov.func_70186_c(d0, d1, d2, 1.6f, 0.0f);
        this.func_184185_a((SoundEvent)WOTWSounds.SOUND_ENTITY_MARTIAN_RAY.get(), 1.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)molotov);
    }

    public LivingEntity func_94060_bK() {
        return super.func_94060_bK();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70146_Z.nextInt(200) == 1 && !((Boolean)this.func_184212_Q().func_187225_a(CHANTING)).booleanValue()) {
            this.func_184212_Q().func_187227_b(CHANTING, (Object)true);
            if (!this.field_70170_p.field_72995_K) {
                this.makeLooters(this.field_70146_Z.nextInt(4));
            }
        }
        if (((Boolean)this.func_184212_Q().func_187225_a(CHANTING)).booleanValue()) {
            ++this.armTime;
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 2.5, this.func_226281_cx_(), 0.0, 0.4, 0.0);
                }
            }
        }
        if (this.armTime >= 100) {
            this.func_184212_Q().func_187227_b(CHANTING, (Object)false);
            this.armTime = 0;
        }
        this.func_70050_g(300);
    }
}

