/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.martian;

import com.swdteam.wotwmod.common.entity.human.LooterEntity;
import com.swdteam.wotwmod.common.entity.martian.MartianEntity;
import com.swdteam.wotwmod.common.init.WOTWBlocks;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWSpawners;
import com.swdteam.wotwmod.common.misc.WOTWConfig;
import com.swdteam.wotwmod.common.utils.EntityUtils;
import com.swdteam.wotwmod.common.utils.MathUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ScalpEntity
extends MartianEntity {
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(ScalpEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    BlockState[] collectableBlocks = new BlockState[]{Blocks.field_150348_b.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150354_m.func_176223_P(), ((Block)WOTWBlocks.RED_WEED_GRASS.get()).func_176223_P(), Blocks.field_150346_d.func_176223_P()};
    public BlockState heldBlock;

    public ScalpEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (!EntityUtils.canSpawnAtLightLevelCheck((LivingEntity)this, spawnReasonIn, this.field_70170_p)) {
            this.func_70106_y();
            return false;
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() == 0) {
            this.func_70106_y();
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)WOTWSpawners.SCALP_SPAWNER.get());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LooterEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.5, 1.5f));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.5, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, LlamaEntity.class, 20.0f, 1.0, 1.2));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            nbt.func_218657_a("carriedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WOTWSounds.SOUND_ENTITY_SMALLMARTIAN_DEATH.get();
    }

    protected void func_191955_a(BlockState state) {
        for (int i = 0; i < this.collectableBlocks.length; ++i) {
            if (state != this.collectableBlocks[i]) continue;
            this.grabBlock(this.func_233580_cy_());
        }
        super.func_191955_a(state);
    }

    public void grabBlock(BlockPos pos) {
        if (this.getHeldBlockState() == null && this.func_70681_au().nextInt(120) == 2) {
            BlockPos bs = pos;
            if (bs == null) {
                bs = this.func_233580_cy_().func_177982_a(MathUtils.randomInt(1, 2), -1, MathUtils.randomInt(1, 2));
            }
            BlockState toCollect = this.field_70170_p.func_180495_p(bs);
            for (int i = 0; i < this.collectableBlocks.length && toCollect.equals(this.collectableBlocks[i]) && !toCollect.equals(Blocks.field_150355_j.func_176223_P()) && !toCollect.equals(Blocks.field_150353_l.func_176223_P()); ++i) {
                this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(toCollect));
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217377_a(bs, false);
            }
        }
    }

    public void func_70030_z() {
        if (((Boolean)WOTWConfig.COMMON.scalper_pickup.get()).booleanValue()) {
            this.grabBlock(null);
        }
        if (this.getHeldBlockState() != null && this.func_70681_au().nextInt(50) == 2) {
            this.chuckBlock();
        }
        super.func_70030_z();
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.setHeldBlockState(blockstate);
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    public void setHeldBlockState(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    public boolean func_204231_K() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
    }

    public void chuckBlock() {
        FallingBlockEntity fbe = new FallingBlockEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getHeldBlockState());
        fbe.func_70024_g((double)MathUtils.randomFloat(-1.0f, 1.0f), (double)MathUtils.randomFloat(0.2f, 1.0f), (double)MathUtils.randomFloat(-1.0f, 1.0f));
        fbe.field_145812_b = 100;
        this.field_70170_p.func_217376_c((Entity)fbe);
        this.setHeldBlockState(null);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_110144_aD() != null) {
            this.func_213395_q(true);
        }
        this.func_70050_g(300);
        this.field_70143_R = 0.0f;
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public void func_70645_a(DamageSource cause) {
        if (this.getHeldBlockState() != null) {
            this.func_199701_a_(new ItemStack((IItemProvider)this.getHeldBlockState().func_177230_c().func_199767_j()));
        }
        super.func_70645_a(cause);
    }

    public void func_174812_G() {
        super.func_174812_G();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WOTWSounds.SOUND_ENTITY_SCALPER_SAY.get();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    @Override
    public LivingEntity func_70643_av() {
        return super.func_70643_av();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }
}

