/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.projectile;

import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.utils.MathUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElectricMachineBoltEntity
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayerEntity caster;

    public ElectricMachineBoltEntity(World worldIn, double x, double y, double z, boolean effectOnlyIn) {
        super(EntityType.field_200728_aG, worldIn);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = effectOnlyIn;
        Difficulty difficulty = worldIn.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void setCaster(@Nullable ServerPlayerEntity casterIn) {
        this.caster = casterIn;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double d3 = (double)this.func_233580_cy_().func_177958_n() + this.field_70146_Z.nextDouble() * (double)0.1f + MathUtils.randomDouble(0.0, 1.0);
                double d8 = (double)this.func_233580_cy_().func_177956_o() + this.field_70146_Z.nextDouble();
                double d13 = (double)this.func_233580_cy_().func_177952_p() + this.field_70146_Z.nextDouble() + MathUtils.randomDouble(-0.1, 0.2);
                this.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d3, d8, d13, 0.0, 0.2, 0.0);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)WOTWSounds.SOUND_ENTITY_ELEC_SHOCK.get(), SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly) {
                double d0 = 3.0;
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 3.0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - 3.0, this.func_226277_ct_() + 3.0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                }
                if (this.caster != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.caster, (Collection)list);
                }
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (!this.effectOnly && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            BlockState blockstate = Blocks.field_150480_ab.func_176223_P();
            BlockPos blockpos = this.func_233580_cy_();
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * ElectricMachineBoltEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

