/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.projectile;

import com.swdteam.wotwmod.common.entity.martian.FightingMachineEntity;
import com.swdteam.wotwmod.common.entity.martian.HeatRayEntity;
import com.swdteam.wotwmod.common.init.WOTWEntities;
import com.swdteam.wotwmod.common.init.WOTWFluids;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.misc.WOTWConfig;
import com.swdteam.wotwmod.common.utils.MathUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MartianLaserEntity
extends ThrowableEntity {
    public LivingEntity shooter;
    private DamageSource damageSource = DamageSource.field_76377_j;
    private float damage = 1.0f;
    private int laser_id = 0;
    public float red = 1.0f;
    public float blue = 1.0f;
    public float green = 1.0f;
    public float alpha = 0.75f;
    public float gravityVelocity = 0.0f;

    public MartianLaserEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public MartianLaserEntity(World worldIn, LivingEntity shooter, BlockPos pos, float damage) {
        super((EntityType)WOTWEntities.ENTITY_MARTIAN_LASER.get(), worldIn);
        this.setShooter(shooter);
        this.func_70107_b(pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
        this.damage = damage;
        this.shooter = shooter;
    }

    public MartianLaserEntity(World worldIn, LivingEntity shooter, BlockPos pos, float damage, float gravVel) {
        super((EntityType)WOTWEntities.ENTITY_MARTIAN_LASER.get(), worldIn);
        this.setShooter(shooter);
        this.func_70107_b(pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
        this.damage = damage;
        this.shooter = shooter;
        this.gravityVelocity = gravVel;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70030_z();
    }

    protected void func_70088_a() {
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.func_233570_aj_() ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult result1 = (EntityRayTraceResult)result;
                Entity entity = result1.func_216348_a();
                if (entity != null && entity != this.shooter) {
                    entity.func_70097_a(this.damageSource, this.damage);
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)result;
                BlockState state = this.field_70170_p.func_180495_p(rayTraceResult.func_216350_a());
                if (((Boolean)WOTWConfig.COMMON.destruction.get()).booleanValue() && !(this.getShooter() instanceof FightingMachineEntity) && !(this.getShooter() instanceof HeatRayEntity)) {
                    this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)((Integer)WOTWConfig.COMMON.martian_explosion_radius.get()).intValue(), Explosion.Mode.DESTROY);
                }
                if (this.field_70170_p.func_180495_p(this.func_233580_cy_()) != Blocks.field_150357_h.func_176223_P()) {
                    this.field_70170_p.func_175656_a(this.func_233580_cy_(), Blocks.field_150480_ab.func_176223_P());
                }
                if (state.func_185904_a().func_76220_a()) {
                    this.func_174812_G();
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
                this.func_184185_a(SoundEvents.field_187659_cY, 0.5f, 1.0f);
            }
            this.field_70170_p.func_175656_a(this.func_233580_cy_(), ((FlowingFluidBlock)WOTWFluids.BW_BLOCK.get()).func_176223_P());
            this.func_174812_G();
        }
        if (this.field_70173_aa % 160 == 0) {
            this.func_174812_G();
        }
    }

    public void setDamageSource(DamageSource sauce) {
        this.damageSource = sauce;
    }

    public void func_174812_G() {
        this.func_184185_a((SoundEvent)WOTWSounds.SOUND_ENTITY_MARTIAN_RAY.get(), 1.0f, MathUtils.randomFloat(0.5f, 1.0f));
        super.func_174812_G();
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity != null) {
            entity.func_70097_a(this.damageSource, this.damage);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

