/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.projectile;

import com.swdteam.wotwmod.common.init.WOTWEntities;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MartianMiningLaserEntity
extends ThrowableEntity {
    public LivingEntity shooter;
    public float explosionSize = 8.0f;
    private boolean isExplosive;
    private DamageSource damageSource = DamageSource.field_76377_j;
    private float damage = 1.0f;
    private int laser_id = 0;
    public float red = 1.0f;
    public float blue = 1.0f;
    public float green = 1.0f;
    public float alpha = 0.75f;

    public MartianMiningLaserEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public MartianMiningLaserEntity(World worldIn, LivingEntity shooter, float yOffset, float damage) {
        super((EntityType)WOTWEntities.ENTITY_MARTIAN_MINING_LASER.get(), worldIn);
        this.setShooter(shooter);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)(0.15f + yOffset), shooter.func_226281_cx_());
        this.damage = damage;
        this.shooter = shooter;
        this.damageSource = new EntityDamageSource(shooter.func_70022_Q(), (Entity)shooter);
    }

    public void func_70030_z() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        super.func_70030_z();
    }

    protected void func_70088_a() {
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        Vector3d vec3d = new Vector3d((double)f, (double)f1, (double)f2).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float fd = MathHelper.func_76133_a((double)MartianMiningLaserEntity.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)fd) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.func_233570_aj_() ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult result1 = (EntityRayTraceResult)result;
                Entity entity = result1.func_216348_a();
                if (entity != null && entity != this.shooter) {
                    entity.func_70097_a(this.damageSource, this.damage);
                    entity.func_70015_d(10);
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)result;
                BlockState state = this.field_70170_p.func_180495_p(rayTraceResult.func_216350_a());
                if (this.field_70170_p.func_180495_p(rayTraceResult.func_216350_a()) != Blocks.field_150357_h.func_176223_P()) {
                    this.field_70170_p.func_175655_b(rayTraceResult.func_216350_a(), true);
                }
                if (state.func_185904_a().func_76220_a()) {
                    this.func_174812_G();
                }
            }
        }
    }

    public void setDamageSource(DamageSource sauce) {
        this.damageSource = sauce;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 80 == 0) {
            this.func_174812_G();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity != null) {
            entity.func_70097_a(this.damageSource, this.damage);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

