/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.init;

import com.swdteam.wotwmod.common.init.WOTWEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;

public class WOTWEntitySpawns {
    public static Map<ResourceLocation, SpawnInfo> spawns = new HashMap<ResourceLocation, SpawnInfo>();

    public static void init() {
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ENTITY_FIGHTING_MACHINE.get(), 1, 1, 1, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.BOMBARDING_MACHINE_ENTITY.get(), 2, 1, 1, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ENTITY_SCALP.get(), 5, 1, 3, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ENTITY_MARTIAN_DRONE.get(), 3, 1, 3, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ENTITY_LOOTER.get(), 6, 1, 4, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ENTITY_FLYING_MACHINE.get(), 1, 1, 3, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.ELECTRIC_MACHINE_ENTITY.get(), 1, 1, 1, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.PROBING_MACHINE_ENTITY.get(), 1, 1, 1, EntityClassification.MONSTER);
        WOTWEntitySpawns.addWOTWSpawn((EntityType)WOTWEntities.EXECUTIONER_ENTITY.get(), 1, 1, 1, EntityClassification.MONSTER);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "lush_biome"), (EntityType)WOTWEntities.MARS_ROACH_ENTITY.get(), 5, 1, 3, EntityClassification.CREATURE);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "lush_biome_heights"), (EntityType)WOTWEntities.MARS_ROACH_ENTITY.get(), 5, 1, 3, EntityClassification.CREATURE);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "tundra_biome"), (EntityType)WOTWEntities.ROCK_SLUG_ENTITY.get(), 5, 1, 3, EntityClassification.CREATURE);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "ash_biome"), (EntityType)WOTWEntities.ASHIGATOR.get(), 2, 1, 3, EntityClassification.MONSTER);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "d47_biome"), (EntityType)WOTWEntities.ENTITY_OCCLUS.get(), 2, 1, 3, EntityClassification.MONSTER);
        WOTWEntitySpawns.removeSpawn((EntityType)WOTWEntities.ENTITY_LOOTER.get(), new ResourceLocation("wotwmod", "mars_biome"), new ResourceLocation("wotwmod", "mars_biome_mountains"), new ResourceLocation("wotwmod", "tundra_biome"), new ResourceLocation("wotwmod", "lush_biome"), new ResourceLocation("wotwmod", "lush_biome_heights"));
        WOTWEntitySpawns.removeSpawn((EntityType)WOTWEntities.ENTITY_MARTIAN_DRONE.get(), new ResourceLocation("wotwmod", "mars_biome"), new ResourceLocation("wotwmod", "mars_biome_mountains"), new ResourceLocation("wotwmod", "tundra_biome"), new ResourceLocation("wotwmod", "lush_biome"), new ResourceLocation("wotwmod", "lush_biome_heights"));
        WOTWEntitySpawns.removeSpawn((EntityType)WOTWEntities.BOMBARDING_MACHINE_ENTITY.get(), new ResourceLocation("wotwmod", "mars_biome"), new ResourceLocation("wotwmod", "mars_biome_mountains"), new ResourceLocation("wotwmod", "tundra_biome"), new ResourceLocation("wotwmod", "lush_biome"), new ResourceLocation("wotwmod", "lush_biome_heights"));
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.ENTITY_FIGHTING_MACHINE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.BOMBARDING_MACHINE_ENTITY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.ENTITY_SCALP.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.ENTITY_MARTIAN_DRONE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.ENTITY_LOOTER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.PROBING_MACHINE_ENTITY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WOTWEntities.EXECUTIONER_ENTITY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private static void addWOTWSpawn(EntityType<?> type, int weight, int min, int max, EntityClassification entityTypeISGC) {
        if (!type.equals((Object)WOTWEntities.EXECUTIONER_ENTITY.get())) {
            WOTWEntitySpawns.addSpawnToAllBiomes(type, weight, min, max, entityTypeISGC);
        }
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "mars_biome"), type, weight, min, max, entityTypeISGC);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "mars_biome_mountains"), type, weight, min, max, entityTypeISGC);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "tundra_biome"), type, weight, min, max, entityTypeISGC);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "lush_biome"), type, weight, min, max, entityTypeISGC);
        WOTWEntitySpawns.addSpawn(new ResourceLocation("wotwmod", "lush_biome_heights"), type, weight, min, max, entityTypeISGC);
        WOTWEntitySpawns.removeSpawn(type, new ResourceLocation("thedalekmod", "tardis_biome"));
        WOTWEntitySpawns.removeSpawn(type, Biomes.field_201939_S, Biomes.field_201938_R, Biomes.field_201937_Q, Biomes.field_201936_P, Biomes.field_76779_k);
        WOTWEntitySpawns.removeSpawn(type, Biomes.field_76788_q, Biomes.field_76789_p);
        if (!type.equals((Object)WOTWEntities.EXECUTIONER_ENTITY.get())) {
            WOTWEntitySpawns.removeSpawn(type, Biomes.field_235252_ay_, Biomes.field_235250_aA_, Biomes.field_235253_az_, Biomes.field_235251_aB_, Biomes.field_235254_j_);
        }
        WOTWEntitySpawns.removeSpawn(type, new ResourceLocation("wotwmod", "forever_autumn_forest"));
    }

    private static void addSpawn(ResourceLocation biome, EntityType<?> type, int weight, int min, int max, EntityClassification entityType) {
        if (!spawns.containsKey(biome)) {
            spawns.put(biome, new SpawnInfo());
        }
        SpawnInfo info = spawns.get(biome);
        info.addSpawn(type, weight, min, max, entityType);
    }

    private static void addSpawnToAllBiomes(EntityType<?> type, int weight, int min, int max, EntityClassification entityType) {
        for (ResourceLocation rl : ForgeRegistries.BIOMES.getKeys()) {
            WOTWEntitySpawns.addSpawn(rl, type, weight, min, max, entityType);
        }
    }

    private static void removeSpawn(EntityType<?> type, ResourceLocation ... biome) {
        for (int i = 0; i < biome.length; ++i) {
            ResourceLocation rl = biome[i];
            if (!spawns.containsKey(rl)) continue;
            SpawnInfo info = spawns.get(rl);
            info.removeSpawn(type);
        }
    }

    private static void removeSpawn(EntityType<?> type, RegistryKey<Biome> ... biome) {
        for (int i = 0; i < biome.length; ++i) {
            RegistryKey<Biome> bi = biome[i];
            if (!spawns.containsKey(bi.func_240901_a_())) continue;
            SpawnInfo info = spawns.get(bi.func_240901_a_());
            info.removeSpawn(type);
        }
    }

    public static class SpawnInfo {
        private List<Spawn> spawners = new ArrayList<Spawn>();

        public void addSpawn(EntityType<?> type, int weight, int min, int max, EntityClassification entType) {
            this.spawners.add(new Spawn(new MobSpawnInfo.Spawners(type, weight, min, max), entType));
        }

        public void removeSpawn(EntityType<?> type) {
            for (int i = 0; i < this.spawners.size(); ++i) {
                Spawn spawn = this.spawners.get(i);
                if (spawn.spawner.field_242588_c != type) continue;
                this.spawners.remove(i);
                break;
            }
        }

        public List<Spawn> getSpawners() {
            return this.spawners;
        }

        public static class Spawn {
            public MobSpawnInfo.Spawners spawner;
            public EntityClassification entityType;

            public Spawn(MobSpawnInfo.Spawners spawner, EntityClassification type) {
                this.spawner = spawner;
                this.entityType = type;
            }
        }
    }
}

