/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="wotwmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModTileEntities {
    public static Map<Class, TileEntityType> TILE_ENTITY_TYPES = new HashMap<Class, TileEntityType>();

    public static <T extends TileEntity> TileEntityType<T> addType(String name, Supplier<TileEntity> tileEntitySupplier, Block ... blocks) {
        TileEntityType.Builder builder = TileEntityType.Builder.func_223042_a(tileEntitySupplier, (Block[])blocks);
        TileEntityType tileEntityType = builder.func_206865_a(null);
        tileEntityType.setRegistryName("wotwmod", name);
        TILE_ENTITY_TYPES.put(tileEntitySupplier.get().getClass(), tileEntityType);
        return tileEntityType;
    }

    public static <T extends TileEntity> TileEntityType<T> getTypeFromClass(Class clazz) {
        if (TILE_ENTITY_TYPES.containsKey(clazz)) {
            return TILE_ENTITY_TYPES.get(clazz);
        }
        return null;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        for (Map.Entry<Class, TileEntityType> entityTypeEntry : TILE_ENTITY_TYPES.entrySet()) {
            event.getRegistry().register((IForgeRegistryEntry)entityTypeEntry.getValue());
        }
    }
}

