/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import me.roundaround.armorstands.client.ArmorStandsClientMod;
import me.roundaround.armorstands.client.gui.MessageRenderer;
import me.roundaround.armorstands.client.gui.widget.HelpButtonWidget;
import me.roundaround.armorstands.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.NavigationButtonWidget;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.mixin.InGameHudAccessor;
import me.roundaround.armorstands.mixin.KeyBindingAccessor;
import me.roundaround.armorstands.mixin.MouseAccessor;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.network.packet.c2s.PingPacket;
import me.roundaround.armorstands.network.packet.c2s.RequestScreenPacket;
import me.roundaround.armorstands.network.packet.c2s.UndoPacket;
import me.roundaround.armorstands.network.packet.c2s.UtilityActionPacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.HasArmorStand;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;

public abstract class AbstractArmorStandScreen
extends class_465<ArmorStandScreenHandler>
implements HasArmorStand,
MessageRenderer.HasMessageRenderer {
    protected static final int SCREEN_EDGE_PAD = 4;
    protected static final int BETWEEN_PAD = 2;
    protected static final int NAV_BUTTON_BOTTOM_PADDING = 1;
    protected static final int NAV_BUTTON_SPACING = 0;
    protected static final class_2960 WIDGETS_TEXTURE = new class_2960("minecraft", "textures/gui/widgets.png");
    protected final class_1531 armorStand;
    protected final MessageRenderer messageRenderer;
    protected final ArrayList<LabelWidget> labels = new ArrayList();
    protected final ArrayList<NavigationButtonWidget<?, ?>> navigationButtons = new ArrayList();
    protected NavigationButtonWidget<?, ?> activeButton;
    protected boolean supportsUndoRedo = false;
    protected boolean utilizesInventory = false;
    protected long currentSyncDelay = 0L;
    private boolean cursorLocked = false;
    private long lastPing = 0L;

    protected AbstractArmorStandScreen(ArmorStandScreenHandler handler, class_2561 title) {
        super((class_1703)handler, handler.getPlayerInventory(), title);
        this.armorStand = handler.getArmorStand();
        this.messageRenderer = new MessageRenderer((class_437)this);
        this.field_22792 = true;
    }

    public abstract ScreenType getScreenType();

    protected LabelWidget addLabel(LabelWidget label) {
        this.labels.add(label);
        return label;
    }

    @Override
    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    @Override
    public MessageRenderer getMessageRenderer() {
        return this.messageRenderer;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        this.initStart();
        super.method_25426();
        this.initLeft();
        this.initNavigationButtons();
        this.initRight();
        this.initEnd();
    }

    protected void method_37432() {
        Arrays.stream(this.field_22787.field_1690.field_1839).filter(key -> key.method_1417(340, 0) || key.method_1417(344, 0)).map(key -> (KeyBindingAccessor)key).forEach(KeyBindingAccessor::invokeReset);
        ((InGameHudAccessor)this.field_22787.field_1705).invokeUpdateVignetteDarkness(this.field_22787.method_1560());
        this.messageRenderer.tick();
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        int adjustedMouseX = this.cursorLocked ? -1 : mouseX;
        int adjustedMouseY = this.cursorLocked ? -1 : mouseY;
        RenderSystem.enableBlend();
        ((InGameHudAccessor)this.field_22787.field_1705).invokeRenderVignetteOverlay(this.field_22787.method_1560());
        for (LabelWidget label : this.labels) {
            label.method_25394(matrixStack, adjustedMouseX, adjustedMouseY, delta);
        }
        super.method_25394(matrixStack, adjustedMouseX, adjustedMouseY, delta);
        this.renderActivePageButtonHighlight(matrixStack);
        this.messageRenderer.render(matrixStack);
    }

    protected void method_2389(class_4587 matrixStack, float delta, int mouseX, int mouseY) {
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.cursorLocked) {
            return;
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.cursorLocked) {
            return false;
        }
        class_364 focused = this.method_25399();
        boolean result = super.method_25402(mouseX, mouseY, button);
        if (this.utilizesInventory) {
            this.method_25395(focused);
        }
        return result;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            return this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25406(mouseX, mouseY, button);
        }
        if (this.method_25397() && this.method_25399() != null && button == 0) {
            this.method_25398(false);
            return this.method_25399().method_25406(mouseX, mouseY, button);
        }
        this.method_25398(false);
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25406(mouseX, mouseY, button)).isPresent();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.cursorLocked) {
            return false;
        }
        for (NavigationButtonWidget<?, ?> button : this.navigationButtons) {
            if (!button.isMouseOverIgnoreState(mouseX, mouseY)) continue;
            if (amount > 0.0) {
                this.goToPreviousScreen();
            } else {
                this.goToNextScreen();
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.cursorLocked) {
            return Optional.empty();
        }
        return super.method_19355(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1903.method_1417(keyCode, scanCode)) {
            return false;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        switch (keyCode) {
            case 256: {
                this.method_25419();
                return true;
            }
            case 342: 
            case 346: {
                if (!this.field_22792) break;
                this.lockCursor();
                return true;
            }
            case 258: {
                boolean forward;
                boolean bl = forward = !class_437.method_25442();
                if (!this.method_25407(forward)) {
                    this.method_25407(forward);
                }
                return false;
            }
            case 263: {
                if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode) && !class_437.method_25441()) break;
                this.playClickSound();
                this.goToPreviousScreen();
                return true;
            }
            case 262: {
                if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode) && !class_437.method_25441()) break;
                this.playClickSound();
                this.goToNextScreen();
                return true;
            }
            case 90: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                this.playClickSound();
                UndoPacket.sendToServer(class_437.method_25442());
                return true;
            }
            case 67: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                this.playClickSound();
                UtilityActionPacket.sendToServer(UtilityAction.COPY);
                return true;
            }
            case 86: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                this.playClickSound();
                UtilityActionPacket.sendToServer(UtilityAction.PASTE);
                return true;
            }
        }
        for (int i = 0; i < this.navigationButtons.size(); ++i) {
            NavigationButtonWidget<?, ?> button = this.navigationButtons.get(i);
            ScreenType screenType = button.getScreenType();
            if (screenType == this.getScreenType() || !this.field_22787.field_1690.field_1852[i].method_1417(keyCode, scanCode)) continue;
            this.playClickSound();
            button.method_25306();
            return true;
        }
        return this.method_25399() != null && this.method_25399().method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.field_22792 && (keyCode == 342 || keyCode == 346)) {
            this.unlockCursor();
            return true;
        }
        return this.method_25399() != null && this.method_25399().method_16803(keyCode, scanCode, modifiers);
    }

    public boolean shouldHighlight(class_1297 entity) {
        return ArmorStandsClientMod.highlightArmorStandKeyBinding.method_1434() && entity == this.armorStand;
    }

    public boolean isCursorLocked() {
        return this.cursorLocked;
    }

    public void sendPing() {
        this.lastPing = System.currentTimeMillis();
        PingPacket.sendToServer(this.field_22787.field_1724);
    }

    public void onPong() {
        this.currentSyncDelay = System.currentTimeMillis() - this.lastPing;
    }

    public void updatePosOnClient(double x, double y, double z) {
        this.armorStand.method_23327(x, y, z);
    }

    public void updateYawOnClient(float yaw) {
        this.armorStand.method_36456(yaw);
    }

    public void updatePitchOnClient(float pitch) {
        this.armorStand.method_36457(pitch);
    }

    public void updateInvulnerableOnClient(boolean invulnerable) {
        this.armorStand.method_5684(invulnerable);
    }

    public void updateDisabledSlotsOnClient(int disabledSlots) {
        ((ArmorStandEntityAccessor)this.armorStand).setDisabledSlots(disabledSlots);
    }

    protected void initStart() {
        this.labels.clear();
        this.navigationButtons.clear();
    }

    protected void initUtilityButtons() {
        if (!this.supportsUndoRedo) {
            return;
        }
        this.method_37063((class_364)new HelpButtonWidget(this.field_22787, this, 4, 4));
        this.method_37063((class_364)new IconButtonWidget<AbstractArmorStandScreen>(this.field_22787, this, 26, 4, 14, (class_2561)class_2561.method_43471((String)"armorstands.utility.copy"), button -> UtilityActionPacket.sendToServer(UtilityAction.COPY)));
        this.method_37063((class_364)new IconButtonWidget<AbstractArmorStandScreen>(this.field_22787, this, 48, 4, 15, (class_2561)class_2561.method_43471((String)"armorstands.utility.paste"), button -> UtilityActionPacket.sendToServer(UtilityAction.PASTE)));
        this.method_37063((class_364)new IconButtonWidget<AbstractArmorStandScreen>(this.field_22787, this, 70, 4, 17, (class_2561)class_2561.method_43471((String)"armorstands.utility.undo"), button -> UndoPacket.sendToServer(false)));
        this.method_37063((class_364)new IconButtonWidget<AbstractArmorStandScreen>(this.field_22787, this, 92, 4, 18, (class_2561)class_2561.method_43471((String)"armorstands.utility.redo"), button -> UndoPacket.sendToServer(true)));
    }

    protected void initLeft() {
        this.initUtilityButtons();
    }

    protected void initNavigationButtons() {
        ScreenType[] screenTypes = ScreenType.values();
        int totalWidth = screenTypes.length * 20 + (screenTypes.length - 1) * 0;
        int x = (this.field_22789 - totalWidth) / 2 - 0;
        int y = this.field_22790 - 1 - 20;
        for (ScreenType screenType : screenTypes) {
            NavigationButtonWidget<?, ?> button = NavigationButtonWidget.create(this.field_22787, this, x, y, screenType);
            if (this.getScreenType() == screenType) {
                this.activeButton = button;
                this.method_37060((class_4068)button);
            } else {
                this.method_37063((class_364)button);
            }
            x += 20;
            this.navigationButtons.add(button);
        }
    }

    protected void initRight() {
    }

    protected void initEnd() {
    }

    protected void renderActivePageButtonHighlight(class_4587 matrixStack) {
        if (this.activeButton == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 100.0);
        this.method_25302(matrixStack, this.activeButton.field_22760 - 2, this.activeButton.field_22761 - 2, 0, 22, 13, 13);
        this.method_25302(matrixStack, this.activeButton.field_22760 + 10 + 1, this.activeButton.field_22761 - 2, 12, 22, 12, 13);
        this.method_25302(matrixStack, this.activeButton.field_22760 - 2, this.activeButton.field_22761 + 10 + 1, 0, 34, 13, 12);
        this.method_25302(matrixStack, this.activeButton.field_22760 + 10 + 1, this.activeButton.field_22761 + 10 + 1, 12, 34, 12, 12);
        matrixStack.method_22909();
    }

    protected void playClickSound() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    protected void lockCursor() {
        this.cursorLocked = true;
        int x = this.field_22787.method_22683().method_4480() / 2;
        int y = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(x);
        ((MouseAccessor)this.field_22787.field_1729).setY(y);
        class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212995, (double)x, (double)y);
    }

    protected void unlockCursor() {
        this.cursorLocked = false;
        int x = this.field_22787.method_22683().method_4480() / 2;
        int y = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(x);
        ((MouseAccessor)this.field_22787.field_1729).setY(y);
        class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212993, (double)x, (double)y);
    }

    protected void goToPreviousScreen() {
        RequestScreenPacket.sendToServer(this.armorStand, this.getScreenType().previous());
    }

    protected void goToNextScreen() {
        RequestScreenPacket.sendToServer(this.armorStand, this.getScreenType().next());
    }
}

