/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.ArrayList;
import java.util.HashMap;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.MoveButtonWidget;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.network.packet.c2s.UtilityActionPacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.MoveMode;
import me.roundaround.armorstands.util.MoveUnits;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5676;

public class ArmorStandMoveScreen
extends AbstractArmorStandScreen {
    private static final int MINI_BUTTON_WIDTH = 28;
    private static final int MINI_BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 46;
    private static final int BUTTON_HEIGHT = 16;
    private final HashMap<class_2350, LabelWidget> directionLabels = new HashMap();
    private final ArrayList<MoveButtonWidget> moveButtons = new ArrayList();
    private LabelWidget playerPosLabel;
    private LabelWidget playerBlockPosLabel;
    private LabelWidget standPosLabel;
    private LabelWidget standBlockPosLabel;
    private LabelWidget facingLabel;
    private class_5676<MoveUnits> unitsButton;
    private MoveMode mode = MoveMode.RELATIVE;
    private MoveUnits units = MoveUnits.PIXELS;

    public ArmorStandMoveScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.MOVE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.MOVE;
    }

    @Override
    protected void initStart() {
        super.initStart();
        this.directionLabels.clear();
        this.moveButtons.clear();
    }

    @Override
    protected void initLeft() {
        super.initLeft();
        this.initCurrentStatus();
        this.initSnapButtons();
    }

    private void initCurrentStatus() {
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.current.player"), 4, 37).alignedTop().justifiedLeft().shiftForPadding().build());
        this.playerPosLabel = this.addLabel(LabelWidget.builder(this.getCurrentPosText((class_1297)this.field_22787.field_1724), 4, 50).alignedTop().justifiedLeft().shiftForPadding().build());
        this.playerBlockPosLabel = this.addLabel(LabelWidget.builder(this.getCurrentBlockPosText((class_1297)this.field_22787.field_1724), 4, 63).alignedTop().justifiedLeft().shiftForPadding().build());
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.current.stand"), 4, 89).alignedTop().justifiedLeft().shiftForPadding().build());
        this.standPosLabel = this.addLabel(LabelWidget.builder(this.getCurrentPosText((class_1297)this.armorStand), 4, 102).alignedTop().justifiedLeft().shiftForPadding().build());
        this.standBlockPosLabel = this.addLabel(LabelWidget.builder(this.getCurrentBlockPosText((class_1297)this.armorStand), 4, 115).alignedTop().justifiedLeft().shiftForPadding().build());
    }

    private void initSnapButtons() {
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.move.snap"), 4, this.field_22790 - 4 - 36).shiftForPadding().justifiedLeft().alignedBottom().build());
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 32 - 2, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.move.snap.standing"), button -> UtilityActionPacket.sendToServer(UtilityAction.SNAP_STANDING)));
        this.method_37063((class_364)new class_4185(52, this.field_22790 - 4 - 32 - 2, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.move.snap.sitting"), button -> UtilityActionPacket.sendToServer(UtilityAction.SNAP_SITTING)));
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.move.snap.corner"), button -> UtilityActionPacket.sendToServer(UtilityAction.SNAP_CORNER)));
        this.method_37063((class_364)new class_4185(52, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.move.snap.center"), button -> UtilityActionPacket.sendToServer(UtilityAction.SNAP_CENTER)));
        this.method_37063((class_364)new class_4185(100, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.move.snap.player"), button -> UtilityActionPacket.sendToServer(UtilityAction.SNAP_PLAYER)));
    }

    @Override
    protected void initRight() {
        super.initRight();
        int topOfMoveButtons = this.field_22790 - 4 - 96 - 10;
        this.method_37063((class_364)class_5676.method_32606(MoveMode::getOptionValueText).method_32624((Object[])MoveMode.values()).method_32619((Object)this.mode).method_32617(this.field_22789 - 4 - 120, topOfMoveButtons - 13 - 6 - 32, 120, 16, MoveMode.getOptionLabelText(), (button, mode) -> {
            this.mode = mode;
            this.units = this.mode.getDefaultUnits();
            this.facingLabel.setText(this.getCurrentFacingText((class_1297)(this.mode.equals((Object)MoveMode.LOCAL_TO_STAND) ? this.armorStand : this.field_22787.field_1724)));
            this.directionLabels.forEach((direction, label) -> label.setText(this.mode.getDirectionText((class_2350)direction)));
            this.unitsButton.method_32605((Object)this.units);
            this.moveButtons.forEach(moveButton -> moveButton.setUnits(this.units));
        }));
        this.unitsButton = (class_5676)this.method_37063((class_364)class_5676.method_32606(MoveUnits::getOptionValueText).method_32624((Object[])MoveUnits.values()).method_32619((Object)this.units).method_32617(this.field_22789 - 4 - 120, topOfMoveButtons - 13 - 4 - 16, 120, 16, MoveUnits.getOptionLabelText(), (button, units) -> {
            this.units = units;
            this.moveButtons.forEach(moveButton -> moveButton.setUnits(this.units));
        }));
        this.facingLabel = this.addLabel(LabelWidget.builder(this.getCurrentFacingText((class_1297)(this.mode.equals((Object)MoveMode.LOCAL_TO_STAND) ? this.armorStand : this.field_22787.field_1724)), this.field_22789 - 4, topOfMoveButtons - 2).shiftForPadding().alignedBottom().justifiedRight().build());
        class_2350[] directions = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11035, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039};
        for (int i = directions.length - 1; i >= 0; --i) {
            this.addRowOfButtons(directions[directions.length - i - 1], i);
        }
    }

    private void addRowOfButtons(class_2350 direction, int index) {
        int refX = this.field_22789 - 4;
        int refY = this.field_22790 - 4 - 16 - index * 18;
        this.directionLabels.put(direction, this.addLabel(LabelWidget.builder(this.mode.getDirectionText(direction), refX - 90, refY + 8).justifiedRight().alignedMiddle().shiftForPadding().build()));
        this.moveButtons.add((MoveButtonWidget)this.method_37063((class_364)new MoveButtonWidget(refX - 84 - 4, refY, 28, 16, direction, 1, this.mode, this.units)));
        this.moveButtons.add((MoveButtonWidget)this.method_37063((class_364)new MoveButtonWidget(refX - 56 - 2, refY, 28, 16, direction, 2, this.mode, this.units)));
        this.moveButtons.add((MoveButtonWidget)this.method_37063((class_364)new MoveButtonWidget(refX - 28, refY, 28, 16, direction, 3, this.mode, this.units)));
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.playerPosLabel.setText(this.getCurrentPosText((class_1297)this.field_22787.field_1724));
        this.playerBlockPosLabel.setText(this.getCurrentBlockPosText((class_1297)this.field_22787.field_1724));
        this.standPosLabel.setText(this.getCurrentPosText((class_1297)this.armorStand));
        this.standBlockPosLabel.setText(this.getCurrentBlockPosText((class_1297)this.armorStand));
        this.facingLabel.setText(this.getCurrentFacingText((class_1297)(this.mode.equals((Object)MoveMode.LOCAL_TO_STAND) ? this.armorStand : this.field_22787.field_1724)));
    }

    private class_2561 getCurrentPosText(class_1297 entity) {
        String xStr = String.format("%.2f", entity.method_23317());
        String yStr = String.format("%.2f", entity.method_23318());
        String zStr = String.format("%.2f", entity.method_23321());
        return class_2561.method_43469((String)"armorstands.current.position", (Object[])new Object[]{xStr, yStr, zStr});
    }

    private class_2561 getCurrentBlockPosText(class_1297 entity) {
        class_2338 pos = entity.method_24515();
        return class_2561.method_43469((String)"armorstands.current.block", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
    }

    private class_2561 getCurrentFacingText(class_1297 entity) {
        float currentRotation = entity.method_36454();
        class_2350 currentFacing = class_2350.method_10150((double)currentRotation);
        String towardsI18n = switch (currentFacing) {
            case class_2350.field_11043 -> "negZ";
            case class_2350.field_11035 -> "posZ";
            case class_2350.field_11039 -> "negX";
            case class_2350.field_11034 -> "posX";
            default -> "posX";
        };
        class_5250 towards = class_2561.method_43471((String)("armorstands.current.facing." + towardsI18n));
        return class_2561.method_43469((String)"armorstands.current.facing", (Object[])new Object[]{currentFacing, towards.getString()});
    }
}

