/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.AdjustPoseSliderWidget;
import me.roundaround.armorstands.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.SimpleTooltipButtonWidget;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.packet.c2s.SetPosePacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.Pose;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5676;
import net.minecraft.class_757;

public class ArmorStandPoseScreen
extends AbstractArmorStandScreen {
    private static final int CONTROL_WIDTH = 100;
    private static final int SLIDER_HEIGHT = 16;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 16;
    private static final int ROW_PAD = 6;
    private static final int PART_PAD_VERTICAL = 10;
    private static final int PART_PAD_HORIZONTAL = 4;
    private PosePart posePart = PosePart.HEAD;
    private IconButtonWidget<ArmorStandPoseScreen> activePosePartButton;
    private IconButtonWidget<ArmorStandPoseScreen> headButton;
    private IconButtonWidget<ArmorStandPoseScreen> bodyButton;
    private IconButtonWidget<ArmorStandPoseScreen> leftArmButton;
    private IconButtonWidget<ArmorStandPoseScreen> rightArmButton;
    private IconButtonWidget<ArmorStandPoseScreen> leftLegButton;
    private IconButtonWidget<ArmorStandPoseScreen> rightLegButton;
    private LabelWidget posePartLabel;
    private AdjustPoseSliderWidget pitchSlider;
    private AdjustPoseSliderWidget yawSlider;
    private AdjustPoseSliderWidget rollSlider;

    public ArmorStandPoseScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.POSE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    public void onArmorStandPoseChanged(class_1531 armorStand, PosePart part) {
        if (this.pitchSlider == null || this.yawSlider == null || this.rollSlider == null) {
            return;
        }
        if (armorStand.method_5628() != this.armorStand.method_5628() || part != this.posePart) {
            return;
        }
        this.pitchSlider.refresh();
        this.yawSlider.refresh();
        this.rollSlider.refresh();
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.POSE;
    }

    @Override
    protected void initLeft() {
        super.initLeft();
        int offset = 16;
        this.headButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4 + 20 + 4, this.field_22790 - 4 - 60 - 20 - 10 - 16, 6, PosePart.HEAD.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.HEAD);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.headButton.field_22763 = false;
        this.activePosePartButton = this.headButton;
        this.method_37063((class_364)this.headButton);
        this.rightArmButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4, this.field_22790 - 4 - 40 - 10 - 10 - 16, 8, PosePart.RIGHT_ARM.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.RIGHT_ARM);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.method_37063((class_364)this.rightArmButton);
        this.bodyButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4 + 20 + 4, this.field_22790 - 4 - 40 - 10 - 10 - 16, 7, PosePart.BODY.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.BODY);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.method_37063((class_364)this.bodyButton);
        this.leftArmButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4 + 40 + 8, this.field_22790 - 4 - 40 - 10 - 10 - 16, 9, PosePart.LEFT_ARM.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.LEFT_ARM);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.method_37063((class_364)this.leftArmButton);
        this.rightLegButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4 + 12, this.field_22790 - 4 - 20 - 10 - 16, 11, PosePart.RIGHT_LEG.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.RIGHT_LEG);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.method_37063((class_364)this.rightLegButton);
        this.leftLegButton = new IconButtonWidget<ArmorStandPoseScreen>(this.field_22787, this, offset + 4 + 12 + 20 + 4, this.field_22790 - 4 - 20 - 10 - 16, 10, PosePart.LEFT_LEG.getDisplayName(), button -> {
            this.setActivePosePart(PosePart.LEFT_LEG);
            this.activePosePartButton.field_22763 = true;
            this.activePosePartButton = button;
            this.activePosePartButton.field_22763 = false;
        });
        this.method_37063((class_364)this.leftLegButton);
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 16, 100, 16, (class_2561)class_2561.method_43471((String)"armorstands.pose.mirror"), button -> {
            SetPosePacket.sendToServer(new Pose(this.armorStand).mirror());
            this.pitchSlider.refresh();
            this.yawSlider.refresh();
            this.rollSlider.refresh();
        }));
    }

    @Override
    protected void initRight() {
        super.initRight();
        this.method_37063((class_364)class_5676.method_32606(SliderRange::getDisplayName).method_32619((Object)SliderRange.FULL).method_32624((Object[])SliderRange.values()).method_32616().method_32617(this.field_22789 - 4 - 100, this.field_22790 - 4 - 48 - 48 - 6 - 18 - 26, 100, 16, (class_2561)class_2561.method_43471((String)"armorstands.pose.range"), (button, value) -> {
            this.pitchSlider.setRange(value.getMin(), value.getMax());
            this.yawSlider.setRange(value.getMin(), value.getMax());
            this.rollSlider.setRange(value.getMin(), value.getMax());
        }));
        this.posePartLabel = this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName().getString()}), this.field_22789 - 4, this.field_22790 - 4 - 48 - 48 - 8 - 18 - 26).shiftForPadding().alignedBottom().justifiedRight().build());
        this.pitchSlider = this.addAdjustSlider(EulerAngleParameter.PITCH, 2);
        this.yawSlider = this.addAdjustSlider(EulerAngleParameter.YAW, 1);
        this.rollSlider = this.addAdjustSlider(EulerAngleParameter.ROLL, 0);
    }

    private AdjustPoseSliderWidget addAdjustSlider(EulerAngleParameter parameter, int index) {
        int refRight = this.field_22789 - 4;
        int refLeft = refRight - 100;
        int refY = this.field_22790 - 4 - 16 - index * 40;
        AdjustPoseSliderWidget slider = new AdjustPoseSliderWidget(refLeft, refY, 100, 16, this.posePart, parameter, this.armorStand);
        this.addLabel(LabelWidget.builder(parameter.getDisplayName(), refLeft, refY - 2).alignedBottom().justifiedLeft().shiftForPadding().build());
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, refRight - 48 - 4, refY - 2 - 16, 16, 16, (class_2561)class_2561.method_43470((String)"-"), (class_2561)class_2561.method_43471((String)"armorstands.pose.subtract"), button -> slider.decrement()));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, refRight - 32 - 2, refY - 2 - 16, 16, 16, (class_2561)class_2561.method_43470((String)"+"), (class_2561)class_2561.method_43471((String)"armorstands.pose.add"), button -> slider.increment()));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, refRight - 16, refY - 2 - 16, 16, 16, (class_2561)class_2561.method_43470((String)"0"), (class_2561)class_2561.method_43471((String)"armorstands.pose.zero"), button -> slider.zero()));
        this.method_37063((class_364)slider);
        return slider;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.pitchSlider != null && this.pitchSlider.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.yawSlider != null && this.yawSlider.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.rollSlider != null && this.rollSlider.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.pitchSlider.tick();
        this.yawSlider.tick();
        this.rollSlider.tick();
    }

    @Override
    protected void renderActivePageButtonHighlight(class_4587 matrixStack) {
        super.renderActivePageButtonHighlight(matrixStack);
        if (this.activePosePartButton == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 100.0);
        this.method_25302(matrixStack, this.activePosePartButton.field_22760 - 2, this.activePosePartButton.field_22761 - 2, 0, 22, 13, 13);
        this.method_25302(matrixStack, this.activePosePartButton.field_22760 + 10 + 1, this.activePosePartButton.field_22761 - 2, 12, 22, 12, 13);
        this.method_25302(matrixStack, this.activePosePartButton.field_22760 - 2, this.activePosePartButton.field_22761 + 10 + 1, 0, 34, 13, 12);
        this.method_25302(matrixStack, this.activePosePartButton.field_22760 + 10 + 1, this.activePosePartButton.field_22761 + 10 + 1, 12, 34, 12, 12);
        matrixStack.method_22909();
    }

    private void setActivePosePart(PosePart part) {
        this.posePart = part;
        this.pitchSlider.setPart(part);
        this.yawSlider.setPart(part);
        this.rollSlider.setPart(part);
        this.posePartLabel.setText((class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName().getString()}));
    }

    private static enum SliderRange {
        FULL(-180, 180),
        HALF(-90, 90),
        TIGHT(-35, 35);

        private final int min;
        private final int max;

        private SliderRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("armorstands.pose.range." + this.name().toLowerCase()));
        }
    }
}

