/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.Locale;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.RotateSliderWidget;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.network.packet.c2s.AdjustYawPacket;
import me.roundaround.armorstands.network.packet.c2s.SetYawPacket;
import me.roundaround.armorstands.network.packet.c2s.UtilityActionPacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ArmorStandRotateScreen
extends AbstractArmorStandScreen {
    private static final int BUTTON_WIDTH = 46;
    private static final int BUTTON_HEIGHT = 16;
    private static final int DIRECTION_BUTTON_WIDTH = 70;
    private static final int MINI_BUTTON_WIDTH = 24;
    private static final int MINI_BUTTON_HEIGHT = 16;
    private static final int SLIDER_WIDTH = 102;
    private static final int SLIDER_HEIGHT = 16;
    private LabelWidget playerFacingLabel;
    private LabelWidget playerRotationLabel;
    private LabelWidget standFacingLabel;
    private LabelWidget standRotationLabel;
    private RotateSliderWidget rotateSlider;

    public ArmorStandRotateScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.ROTATE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.ROTATE;
    }

    @Override
    protected void initLeft() {
        super.initLeft();
        this.initCurrentStatus();
        this.initSnapButtons();
        this.initFaceButtons();
    }

    private void initCurrentStatus() {
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.current.player"), 4, 37).alignedTop().justifiedLeft().shiftForPadding().build());
        this.playerFacingLabel = this.addLabel(LabelWidget.builder(this.getCurrentFacingText((class_1297)this.field_22787.field_1724), 4, 50).alignedTop().justifiedLeft().shiftForPadding().build());
        this.playerRotationLabel = this.addLabel(LabelWidget.builder(this.getCurrentRotationText((class_1297)this.field_22787.field_1724), 4, 63).alignedTop().justifiedLeft().shiftForPadding().build());
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.current.stand"), 4, 89).alignedTop().justifiedLeft().shiftForPadding().build());
        this.standFacingLabel = this.addLabel(LabelWidget.builder(this.getCurrentFacingText((class_1297)this.armorStand), 4, 102).alignedTop().justifiedLeft().shiftForPadding().build());
        this.standRotationLabel = this.addLabel(LabelWidget.builder(this.getCurrentRotationText((class_1297)this.armorStand), 4, 115).alignedTop().justifiedLeft().shiftForPadding().build());
    }

    private void initSnapButtons() {
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.rotate.snap"), 4, this.field_22790 - 4 - 48 - 8 - 13).shiftForPadding().justifiedLeft().alignedBottom().build());
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 48 - 6 - 13, 70, 16, (class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11035.method_10151())), button -> SetYawPacket.sendToServer(class_3532.method_15393((float)class_2350.field_11035.method_10144()))));
        this.method_37063((class_364)new class_4185(76, this.field_22790 - 4 - 48 - 6 - 13, 70, 16, (class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11043.method_10151())), button -> SetYawPacket.sendToServer(class_3532.method_15393((float)class_2350.field_11043.method_10144()))));
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 32 - 4 - 13, 70, 16, (class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11034.method_10151())), button -> SetYawPacket.sendToServer(class_3532.method_15393((float)class_2350.field_11034.method_10144()))));
        this.method_37063((class_364)new class_4185(76, this.field_22790 - 4 - 32 - 4 - 13, 70, 16, (class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11039.method_10151())), button -> SetYawPacket.sendToServer(class_3532.method_15393((float)class_2350.field_11039.method_10144()))));
    }

    private void initFaceButtons() {
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.rotate.face"), 4, this.field_22790 - 4 - 16 - 2).shiftForPadding().justifiedLeft().alignedBottom().build());
        this.method_37063((class_364)new class_4185(4, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.rotate.face.toward"), button -> UtilityActionPacket.sendToServer(UtilityAction.FACE_TOWARD)));
        this.method_37063((class_364)new class_4185(52, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.rotate.face.away"), button -> UtilityActionPacket.sendToServer(UtilityAction.FACE_AWAY)));
        this.method_37063((class_364)new class_4185(100, this.field_22790 - 4 - 16, 46, 16, (class_2561)class_2561.method_43471((String)"armorstands.rotate.face.with"), button -> UtilityActionPacket.sendToServer(UtilityAction.FACE_WITH)));
    }

    @Override
    protected void initRight() {
        super.initRight();
        this.addRowOfButtons(RotateDirection.CLOCKWISE, 1);
        this.addRowOfButtons(RotateDirection.COUNTERCLOCKWISE, 0);
        this.rotateSlider = (RotateSliderWidget)this.method_37063((class_364)new RotateSliderWidget(this, this.field_22789 - 4 - 102, this.field_22790 - 4 - 16, 102, 16, this.armorStand));
    }

    private void addRowOfButtons(RotateDirection direction, int index) {
        int refX = this.field_22789 - 4 - 24;
        int refY = this.field_22790 - 4 - 16 - 4 - 16 - index * 33;
        String modifier = direction.equals((Object)RotateDirection.CLOCKWISE) ? "+" : "-";
        this.addLabel(LabelWidget.builder(direction.getLabel(), this.field_22789 - 4, refY - 2).justifiedRight().alignedBottom().shiftForPadding().build());
        this.method_37063((class_364)new class_4185(refX - 78, refY, 24, 16, (class_2561)class_2561.method_43470((String)(modifier + "1")), button -> AdjustYawPacket.sendToServer(direction.offset() * 1)));
        this.method_37063((class_364)new class_4185(refX - 52, refY, 24, 16, (class_2561)class_2561.method_43470((String)(modifier + "5")), button -> AdjustYawPacket.sendToServer(direction.offset() * 5)));
        this.method_37063((class_364)new class_4185(refX - 26, refY, 24, 16, (class_2561)class_2561.method_43470((String)(modifier + "15")), button -> AdjustYawPacket.sendToServer(direction.offset() * 15)));
        this.method_37063((class_364)new class_4185(refX, refY, 24, 16, (class_2561)class_2561.method_43470((String)(modifier + "45")), button -> AdjustYawPacket.sendToServer(direction.offset() * 45)));
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.playerFacingLabel.setText(this.getCurrentFacingText((class_1297)this.field_22787.field_1724));
        this.playerRotationLabel.setText(this.getCurrentRotationText((class_1297)this.field_22787.field_1724));
        this.standFacingLabel.setText(this.getCurrentFacingText((class_1297)this.armorStand));
        this.standRotationLabel.setText(this.getCurrentRotationText((class_1297)this.armorStand));
        this.rotateSlider.tick();
    }

    @Override
    public void updateYawOnClient(float yaw) {
        if (this.rotateSlider != null && this.rotateSlider.isPending((class_437)this)) {
            return;
        }
        super.updateYawOnClient(yaw);
        if (this.rotateSlider != null) {
            this.rotateSlider.setAngle(yaw);
        }
    }

    @Override
    public void onPong() {
        super.onPong();
        if (this.rotateSlider != null) {
            this.rotateSlider.onPong();
        }
    }

    private class_2561 getCurrentFacingText(class_1297 entity) {
        float currentRotation = entity.method_36454();
        class_2350 currentFacing = class_2350.method_10150((double)currentRotation);
        String towardsI18n = switch (currentFacing) {
            case class_2350.field_11043 -> "negZ";
            case class_2350.field_11035 -> "posZ";
            case class_2350.field_11039 -> "negX";
            case class_2350.field_11034 -> "posX";
            default -> "posX";
        };
        class_5250 towards = class_2561.method_43471((String)("armorstands.current.facing." + towardsI18n));
        return class_2561.method_43469((String)"armorstands.current.facing", (Object[])new Object[]{currentFacing, towards.getString()});
    }

    private class_2561 getCurrentRotationText(class_1297 entity) {
        float currentRotation = entity.method_36454();
        return class_2561.method_43469((String)"armorstands.current.rotation", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", Float.valueOf(class_3532.method_15393((float)currentRotation)))});
    }

    public static enum RotateDirection {
        CLOCKWISE(1, "armorstands.rotate.clockwise"),
        COUNTERCLOCKWISE(-1, "armorstands.rotate.counter");

        private final int offset;
        private final class_2561 label;

        private RotateDirection(int offset, String i18n) {
            this.offset = offset;
            this.label = class_2561.method_43471((String)i18n);
        }

        public int offset() {
            return this.offset;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label.getString();
        }

        public RotateDirection getOpposite() {
            return this == CLOCKWISE ? COUNTERCLOCKWISE : CLOCKWISE;
        }
    }
}

