/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.ArmorStandFlagToggleWidget;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.client.gui.widget.SimpleTooltipButtonWidget;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.network.packet.c2s.UtilityActionPacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ArmorStandUtilitiesScreen
extends AbstractArmorStandScreen {
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 16;
    private final HashMap<ArmorStandFlag, Boolean> currentValues = new HashMap();
    private final HashMap<ArmorStandFlag, Consumer<Boolean>> listeners = new HashMap();

    public ArmorStandUtilitiesScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.UTILITIES.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.UTILITIES;
    }

    @Override
    protected void initStart() {
        super.initStart();
        this.listeners.clear();
        this.refreshFlags();
    }

    @Override
    protected void initLeft() {
        super.initLeft();
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.utility.setup"), 4, this.field_22790 - 4 - 48 - 6).alignedBottom().justifiedLeft().shiftForPadding().build());
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 4, this.field_22790 - 4 - 48 - 4, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.prepare"), (class_2561)class_2561.method_43471((String)"armorstands.utility.prepare.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.PREPARE)));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 66, this.field_22790 - 4 - 48 - 4, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.toolRack"), (class_2561)class_2561.method_43471((String)"armorstands.utility.toolRack.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.TOOL_RACK)));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 4, this.field_22790 - 4 - 32 - 2, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.uprightItem"), (class_2561)class_2561.method_43471((String)"armorstands.utility.uprightItem.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.UPRIGHT_ITEM.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 66, this.field_22790 - 4 - 32 - 2, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.flatItem"), (class_2561)class_2561.method_43471((String)"armorstands.utility.flatItem.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.FLAT_ITEM.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 4, this.field_22790 - 4 - 16, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.block"), (class_2561)class_2561.method_43471((String)"armorstands.utility.block.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.BLOCK.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))));
        this.method_37063((class_364)new SimpleTooltipButtonWidget((class_437)this, 66, this.field_22790 - 4 - 16, 60, 16, (class_2561)class_2561.method_43471((String)"armorstands.utility.tool"), (class_2561)class_2561.method_43471((String)"armorstands.utility.tool.tooltip"), button -> UtilityActionPacket.sendToServer(UtilityAction.TOOL.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))));
    }

    @Override
    protected void initRight() {
        super.initRight();
        List<ArmorStandFlag> flags = ArmorStandFlag.getFlags();
        for (int i = flags.size() - 1; i >= 0; --i) {
            this.addFlagToggleWidget(flags.get(flags.size() - i - 1), i);
        }
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.refreshFlags();
    }

    private void refreshFlags() {
        Arrays.stream(ArmorStandFlag.values()).forEach(flag -> {
            boolean curr;
            Consumer<Boolean> listener = this.listeners.getOrDefault(flag, value -> {});
            boolean prev = this.currentValues.getOrDefault(flag, !(curr = flag.getValue(this.armorStand)));
            if (curr != prev) {
                this.currentValues.put((ArmorStandFlag)((Object)flag), curr);
                listener.accept(curr);
            }
        });
    }

    private void addFlagToggleWidget(ArmorStandFlag flag, int index) {
        int xPos = this.field_22789 - 4;
        int yPos = this.field_22790 - (index + 1) * 16;
        ArmorStandFlagToggleWidget widget = new ArmorStandFlagToggleWidget(this.field_22793, flag, this.currentValues.get((Object)flag), xPos, yPos);
        this.method_37063((class_364)widget);
        this.listeners.put(flag, t -> widget.setValue((boolean)t));
    }
}

