/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.widget;

import java.util.Optional;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.network.packet.c2s.SetYawPacket;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_437;

public class RotateSliderWidget
extends class_357 {
    private final AbstractArmorStandScreen parent;
    private final class_1531 armorStand;
    private Optional<Float> lastAngle = Optional.empty();
    private int min = -180;
    private int max = 180;
    private Optional<Long> lastScroll = Optional.empty();
    private boolean isDragging = false;
    private boolean pendingDragPing = false;

    public RotateSliderWidget(AbstractArmorStandScreen parent, int x, int y, int width, int height, class_1531 armorStand) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.parent = parent;
        this.armorStand = armorStand;
        this.refresh();
    }

    public boolean isPending(class_437 parent) {
        return this.isDragging() || this.lastScroll.isPresent();
    }

    public void setRange(int min, int max) {
        this.min = min;
        this.max = max;
        this.refresh();
    }

    public void refresh() {
        float armorStandAngle = this.armorStand.method_36454();
        if (this.lastAngle.isPresent() && Math.abs(armorStandAngle - this.lastAngle.get().floatValue()) < 1.0E-5f) {
            return;
        }
        this.lastAngle = Optional.of(Float.valueOf(armorStandAngle));
        this.setAngle(armorStandAngle);
    }

    public void zero() {
        this.setAngle(0.0f);
        this.persistValue();
    }

    public void increment() {
        double up = Math.ceil(this.getAngle());
        if (up - (double)this.getAngle() < (double)1.0E-5f) {
            up += 1.0;
        }
        this.setAngle((float)up);
        this.persistValue();
    }

    public void decrement() {
        double down = Math.floor(this.getAngle());
        if ((double)this.getAngle() - down < (double)1.0E-5f) {
            down -= 1.0;
        }
        this.setAngle((float)down);
        this.persistValue();
    }

    public void tick() {
        this.lastScroll.ifPresent(lastScroll -> {
            if (System.currentTimeMillis() - lastScroll > 500L) {
                this.lastScroll = Optional.empty();
                this.persistValue();
            }
        });
    }

    public boolean isDragging() {
        return this.isDragging || this.pendingDragPing;
    }

    public void onPong() {
        this.pendingDragPing = false;
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43469((String)"armorstands.rotate.label", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getAngle()))}));
    }

    protected void method_25344() {
        this.armorStand.method_36456(this.getAngle());
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.isDragging = true;
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        this.isDragging = false;
        this.pendingDragPing = true;
        this.parent.sendPing();
        this.persistValue();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.method_25405(mouseX, mouseY)) {
            this.setAngle(this.getAngle() + (float)amount);
            this.method_25344();
            this.lastScroll = Optional.of(System.currentTimeMillis());
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.decrement();
            return true;
        }
        if (keyCode == 262) {
            this.increment();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.isDragging = true;
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    public void method_25354(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    private float getAngle() {
        return RotateSliderWidget.valueToAngle(this.field_22753, this.min, this.max);
    }

    public void setAngle(float value) {
        this.setValue(RotateSliderWidget.angleToValue(value, this.min, this.max));
    }

    private void setValue(double value) {
        this.field_22753 = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        this.method_25346();
    }

    private static double angleToValue(float value, int min, int max) {
        return (value - (float)min) / (float)(max - min);
    }

    private static float valueToAngle(double value, int min, int max) {
        return (float)(value * (double)(max - min) + (double)min);
    }

    private void persistValue() {
        this.lastScroll = Optional.empty();
        SetYawPacket.sendToServer(this.getAngle());
    }
}

