/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.util;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.SavedPose;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1531;
import net.minecraft.class_3518;

public class PoseStorage {
    private static final File FILE = FabricLoader.getInstance().getGameDir().resolve("armorstandsposes.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static HashMap<UUID, SavedPose> map = new HashMap();

    public static void add(String name, class_1531 armorStand) {
        PoseStorage.add(name, new Pose(armorStand));
    }

    public static void add(String name, Pose pose) {
        UUID uuid = UUID.randomUUID();
        try {
            map.put(uuid, new SavedPose(name, pose));
            PoseStorage.save();
        }
        catch (IOException e) {
            map.remove(uuid);
            e.printStackTrace();
        }
    }

    public static void rename(UUID uuid, String name) {
        try {
            SavedPose savedPose = map.get(uuid);
            if (savedPose == null) {
                return;
            }
            map.put(uuid, new SavedPose(name, savedPose.toPose()));
            PoseStorage.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void remove(UUID uuid) {
        try {
            map.remove(uuid);
            PoseStorage.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        try {
            PoseStorage.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<UUID, SavedPose> getPoses() {
        return Map.copyOf(map);
    }

    private static void save() throws IOException {
        JsonArray jsonArray = new JsonArray();
        map.values().stream().map(SavedPose::toJson).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter bufferedWriter = Files.newWriter((File)FILE, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonArray, (Appendable)bufferedWriter);
        }
    }

    private static void load() throws IOException {
        if (!FILE.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = Files.newReader((File)FILE, (Charset)StandardCharsets.UTF_8);){
            map.clear();
            JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"entry");
                map.put(UUID.randomUUID(), SavedPose.fromJson(jsonObject));
            }
        }
    }
}

