/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.network.packet.c2s;

import io.netty.buffer.ByteBuf;
import me.roundaround.armorstands.network.NetworkHelpers;
import me.roundaround.armorstands.network.packet.NetworkPackets;
import me.roundaround.armorstands.util.ArmorStandEditor;
import me.roundaround.armorstands.util.HasArmorStandEditor;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.SavedPose;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2379;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class SetPosePacket {
    private final class_2379 head;
    private final class_2379 body;
    private final class_2379 rightArm;
    private final class_2379 leftArm;
    private final class_2379 rightLeg;
    private final class_2379 leftLeg;

    public SetPosePacket(class_2540 buf) {
        this.head = NetworkHelpers.readEulerAngle(buf);
        this.body = NetworkHelpers.readEulerAngle(buf);
        this.rightArm = NetworkHelpers.readEulerAngle(buf);
        this.leftArm = NetworkHelpers.readEulerAngle(buf);
        this.rightLeg = NetworkHelpers.readEulerAngle(buf);
        this.leftLeg = NetworkHelpers.readEulerAngle(buf);
    }

    public SetPosePacket(SavedPose pose) {
        this(pose.toPose());
    }

    public SetPosePacket(Pose pose) {
        this(pose.getHead(), pose.getBody(), pose.getRightArm(), pose.getLeftArm(), pose.getRightLeg(), pose.getLeftLeg());
    }

    public SetPosePacket(class_2379 head, class_2379 body, class_2379 rightArm, class_2379 leftArm, class_2379 rightLeg, class_2379 leftLeg) {
        this.head = head;
        this.body = body;
        this.rightArm = rightArm;
        this.leftArm = leftArm;
        this.rightLeg = rightLeg;
        this.leftLeg = leftLeg;
    }

    private class_2540 toPacket() {
        class_2540 buf = new class_2540((ByteBuf)PacketByteBufs.create());
        NetworkHelpers.writeEulerAngle(buf, this.head);
        NetworkHelpers.writeEulerAngle(buf, this.body);
        NetworkHelpers.writeEulerAngle(buf, this.rightArm);
        NetworkHelpers.writeEulerAngle(buf, this.leftArm);
        NetworkHelpers.writeEulerAngle(buf, this.rightLeg);
        NetworkHelpers.writeEulerAngle(buf, this.leftLeg);
        return buf;
    }

    private void handleOnServer(MinecraftServer server, class_3222 player, class_3244 handler, PacketSender responseSender) {
        if (!(player.field_7512 instanceof HasArmorStandEditor)) {
            return;
        }
        HasArmorStandEditor screenHandler = (HasArmorStandEditor)player.field_7512;
        ArmorStandEditor editor = screenHandler.getEditor();
        editor.setPose(this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg);
    }

    public static void sendToServer(SavedPose pose) {
        ClientPlayNetworking.send((class_2960)NetworkPackets.SET_POSE_PACKET, (class_2540)new SetPosePacket(pose).toPacket());
    }

    public static void sendToServer(Pose pose) {
        ClientPlayNetworking.send((class_2960)NetworkPackets.SET_POSE_PACKET, (class_2540)new SetPosePacket(pose).toPacket());
    }

    public static void sendToServer(class_2379 head, class_2379 body, class_2379 rightArm, class_2379 leftArm, class_2379 rightLeg, class_2379 leftLeg) {
        ClientPlayNetworking.send((class_2960)NetworkPackets.SET_POSE_PACKET, (class_2540)new SetPosePacket(head, body, rightArm, leftArm, rightLeg, leftLeg).toPacket());
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)NetworkPackets.SET_POSE_PACKET, (server, player, handler, buf, responseSender) -> new SetPosePacket(buf).handleOnServer(server, player, handler, responseSender));
    }
}

