/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.stream.Stream;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.server.ArmorStandUsers;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_3324;
import net.minecraft.class_3330;
import net.minecraft.class_3337;
import net.minecraft.class_3340;

public class ArmorStandsCommand {
    private static final SimpleCommandExceptionType ADD_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"armorstands.commands.add.failed"));
    private static final SimpleCommandExceptionType REMOVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"armorstands.commands.remove.failed"));
    private static final SimpleCommandExceptionType RELOAD_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"armorstands.commands.reload.failed"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"armorstands").requires(source -> source.method_43737() && (source.method_9259(2) || source.method_9211().method_3724()));
        LiteralArgumentBuilder addSub = (LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            Stream<String> playerNames = playerManager.method_14571().stream().filter(player -> !ArmorStandUsers.isExplicitlyListed(player)).map(player -> player.method_7334().getName());
            return class_2172.method_9264(playerNames, (SuggestionsBuilder)builder);
        }).executes(context -> ArmorStandsCommand.executeAdd((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"))));
        LiteralArgumentBuilder removeSub = (LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9253((String[])ArmorStandUsers.getNames(), (SuggestionsBuilder)builder)).executes(context -> ArmorStandsCommand.executeRemove((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets"))));
        LiteralArgumentBuilder reloadSub = (LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(context -> ArmorStandsCommand.executeReload((class_2168)context.getSource()));
        LiteralArgumentBuilder finalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)baseCommand.then((ArgumentBuilder)addSub)).then((ArgumentBuilder)removeSub)).then((ArgumentBuilder)reloadSub);
        dispatcher.register(finalCommand);
    }

    private static int executeAdd(class_2168 source, Collection<GameProfile> targets) throws CommandSyntaxException {
        class_3337 whitelist = ArmorStandUsers.WHITELIST;
        int added = 0;
        for (GameProfile profile : targets) {
            if (whitelist.method_14653(profile)) continue;
            class_3340 entry = new class_3340(profile);
            whitelist.method_14633((class_3330)entry);
            source.method_9226((class_2561)class_2561.method_43469((String)"armorstands.commands.add.success", (Object[])new Object[]{class_2564.method_10882((GameProfile)profile)}), true);
            ++added;
        }
        if (added == 0) {
            throw ADD_FAILED_EXCEPTION.create();
        }
        return added;
    }

    private static int executeRemove(class_2168 source, Collection<GameProfile> targets) throws CommandSyntaxException {
        class_3337 whitelist = ArmorStandUsers.WHITELIST;
        int removed = 0;
        for (GameProfile profile : targets) {
            if (!whitelist.method_14653(profile)) continue;
            class_3340 entry = new class_3340(profile);
            whitelist.method_14638((class_3330)entry);
            source.method_9226((class_2561)class_2561.method_43469((String)"armorstands.commands.remove.success", (Object[])new Object[]{class_2564.method_10882((GameProfile)profile)}), true);
            ++removed;
        }
        if (removed == 0) {
            throw REMOVE_FAILED_EXCEPTION.create();
        }
        return removed;
    }

    private static int executeReload(class_2168 source) throws CommandSyntaxException {
        try {
            ArmorStandUsers.WHITELIST.method_14630();
        }
        catch (Exception exception) {
            ArmorStandsMod.LOGGER.warn("Failed to reload armor stand users: ", (Throwable)exception);
            throw RELOAD_FAILED_EXCEPTION.create();
        }
        source.method_9226((class_2561)class_2561.method_43471((String)"armorstands.commands.reload.success"), true);
        return 1;
    }
}

