/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.util.Pose;
import net.minecraft.class_2379;
import net.minecraft.class_2561;

public enum PosePreset implements Pose.PoseSupplier
{
    DEFAULT("default", Source.VANILLA, Category.STANDING, new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(-15.0f, 0.0f, 10.0f), new class_2379(-10.0f, 0.0f, -10.0f), new class_2379(1.0f, 0.0f, 1.0f), new class_2379(-1.0f, 0.0f, -1.0f)),
    ATTENTION("attention", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f)),
    CONFIDENT("confident", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(-10.0f, 20.0f, 0.0f), new class_2379(-2.0f, 0.0f, 0.0f), new class_2379(5.0f, 0.0f, 0.0f), new class_2379(5.0f, 0.0f, 0.0f), new class_2379(16.0f, 2.0f, 10.0f), new class_2379(0.0f, -10.0f, -4.0f)),
    WALKING("walking", Source.VANILLA_TWEAKS, Category.MOVING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(20.0f, 0.0f, 10.0f), new class_2379(-20.0f, 0.0f, -10.0f), new class_2379(-20.0f, 0.0f, 0.0f), new class_2379(20.0f, 0.0f, 0.0f)),
    RUNNING("running", Source.VANILLA_TWEAKS, Category.MOVING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(-40.0f, 0.0f, 10.0f), new class_2379(40.0f, 0.0f, -10.0f), new class_2379(-40.0f, 0.0f, 0.0f), new class_2379(40.0f, 0.0f, 0.0f)),
    LUNGING("lunging", Source.VANILLA_TWEAKS, Category.MOVING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(15.0f, 0.0f, 0.0f), new class_2379(-60.0f, -10.0f, 0.0f), new class_2379(10.0f, 0.0f, -10.0f), new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(30.0f, 0.0f, 0.0f)),
    POINTING("pointing", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(0.0f, 20.0f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(-90.0f, 18.0f, 0.0f), new class_2379(0.0f, 0.0f, -10.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f)),
    FACEPALM("facepalm", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(45.0f, -4.0f, 1.0f), new class_2379(10.0f, 0.0f, 0.0f), new class_2379(18.0f, -14.0f, 0.0f), new class_2379(-72.0f, 24.0f, 47.0f), new class_2379(25.0f, -2.0f, 0.0f), new class_2379(-4.0f, -6.0f, -2.0f)),
    BLOCKING("blocking", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(-20.0f, -20.0f, 0.0f), new class_2379(-50.0f, 50.0f, 0.0f), new class_2379(-20.0f, 0.0f, 0.0f), new class_2379(20.0f, 0.0f, 0.0f)),
    CONFUSED("confused", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(0.0f, 30.0f, 0.0f), new class_2379(0.0f, 13.0f, 0.0f), new class_2379(-22.0f, 31.0f, 10.0f), new class_2379(145.0f, 22.0f, -49.0f), new class_2379(6.0f, -20.0f, 0.0f), new class_2379(-6.0f, 0.0f, 0.0f)),
    WINNING("winning", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(-120.0f, -10.0f, 0.0f), new class_2379(10.0f, 0.0f, -10.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(15.0f, 0.0f, 0.0f)),
    FORMAL("formal", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(4.0f, 0.0f, 0.0f), new class_2379(4.0f, 0.0f, 0.0f), new class_2379(30.0f, 22.0f, -20.0f), new class_2379(30.0f, -20.0f, 21.0f), new class_2379(0.0f, 0.0f, 5.0f), new class_2379(0.0f, 0.0f, -5.0f)),
    SALUTE("salute", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(5.0f, 0.0f, 0.0f), new class_2379(-124.0f, -51.0f, -35.0f), new class_2379(29.0f, 0.0f, 25.0f), new class_2379(0.0f, -4.0f, -2.0f), new class_2379(0.0f, 4.0f, 2.0f)),
    SAD("sad", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(63.0f, 0.0f, 0.0f), new class_2379(10.0f, 0.0f, 0.0f), new class_2379(-5.0f, 0.0f, 5.0f), new class_2379(-5.0f, 0.0f, -5.0f), new class_2379(-5.0f, -10.0f, 5.0f), new class_2379(-5.0f, 16.0f, -5.0f)),
    ARABESQUE("arabesque", Source.VANILLA_TWEAKS, Category.DYNAMIC, new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(10.0f, 0.0f, 0.0f), new class_2379(-140.0f, -10.0f, 0.0f), new class_2379(70.0f, 0.0f, -10.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(75.0f, 0.0f, 0.0f)),
    CANCAN("cancan", Source.BEDROCK, Category.DYNAMIC, new class_2379(-5.0f, 18.0f, 0.0f), new class_2379(0.0f, 22.0f, 0.0f), new class_2379(0.0f, 84.0f, 111.0f), new class_2379(8.0f, 0.0f, -114.0f), new class_2379(0.0f, 23.0f, -13.0f), new class_2379(-111.0f, 55.0f, 0.0f)),
    JOYOUS("joyous", Source.VANILLA_TWEAKS, Category.DYNAMIC, new class_2379(-11.0f, 0.0f, 0.0f), new class_2379(-4.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 100.0f), new class_2379(0.0f, 0.0f, -100.0f), new class_2379(-8.0f, 0.0f, 60.0f), new class_2379(-8.0f, 0.0f, -60.0f)),
    CUPID("cupid", Source.VANILLA_TWEAKS, Category.DYNAMIC, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(10.0f, 0.0f, 0.0f), new class_2379(-90.0f, -10.0f, 0.0f), new class_2379(-75.0f, 0.0f, 10.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(75.0f, 0.0f, 0.0f)),
    STARGAZING("stargazing", Source.VANILLA_TWEAKS, Category.STANDING, new class_2379(-22.0f, 25.0f, 0.0f), new class_2379(-4.0f, 10.0f, 0.0f), new class_2379(-153.0f, 34.0f, -3.0f), new class_2379(4.0f, 18.0f, 0.0f), new class_2379(-4.0f, 17.0f, 2.0f), new class_2379(6.0f, 24.0f, 0.0f)),
    GUARD("guard", Source.BEDROCK, Category.STANDING, new class_2379(-5.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 2.0f), new class_2379(-60.0f, 20.0f, -10.0f), new class_2379(10.0f, 0.0f, -5.0f), new class_2379(3.0f, 3.0f, 3.0f), new class_2379(-3.0f, -3.0f, -3.0f)),
    BRANDISH("brandish", Source.BEDROCK, Category.STANDING, new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, -2.0f), new class_2379(-110.0f, 50.0f, 0.0f), new class_2379(20.0f, 0.0f, -10.0f), new class_2379(-5.0f, 3.0f, 3.0f), new class_2379(5.0f, -3.0f, -3.0f)),
    SPEAKING("speaking", Source.BEDROCK, Category.STANDING, new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(-110.0f, 35.0f, 0.0f), new class_2379(-110.0f, -35.0f, 0.0f), new class_2379(-5.0f, 3.0f, 3.0f), new class_2379(5.0f, -3.0f, -3.0f)),
    INSPIRING("inspiring", Source.BEDROCK, Category.STANDING, new class_2379(-4.0f, 67.0f, 0.0f), new class_2379(0.0f, 8.0f, 0.0f), new class_2379(-99.0f, 63.0f, 0.0f), new class_2379(16.0f, 32.0f, -8.0f), new class_2379(4.0f, 63.0f, 8.0f), new class_2379(0.0f, -75.0f, -8.0f)),
    THANKING("thanking", Source.BEDROCK, Category.STANDING, new class_2379(-15.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(-110.0f, -35.0f, 0.0f), new class_2379(-110.0f, 35.0f, 0.0f), new class_2379(-5.0f, 3.0f, 3.0f), new class_2379(5.0f, -3.0f, -3.0f)),
    DABBING("dabbing", Source.BEDROCK, Category.DYNAMIC, new class_2379(16.0f, 20.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(246.0f, 0.0f, 89.0f), new class_2379(4.0f, 8.0f, 237.0f), new class_2379(8.0f, 20.0f, 4.0f), new class_2379(-14.0f, -18.0f, -16.0f)),
    PLEDGING("pledging", Source.BEDROCK, Category.STANDING, new class_2379(0.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(-70.0f, -40.0f, 0.0f), new class_2379(10.0f, 0.0f, -5.0f), new class_2379(1.0f, 0.0f, 1.0f), new class_2379(-1.0f, 0.0f, -1.0f)),
    CONTEMPLATING("contemplating", Source.BEDROCK, Category.STANDING, new class_2379(15.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 2.0f), new class_2379(-60.0f, -20.0f, -10.0f), new class_2379(-30.0f, 15.0f, 15.0f), new class_2379(1.0f, 0.0f, 1.0f), new class_2379(-1.0f, 0.0f, -1.0f)),
    ZOMBIE("zombie", Source.BEDROCK, Category.MOVING, new class_2379(-10.0f, 0.0f, -5.0f), new class_2379(0.0f, 0.0f, 0.0f), new class_2379(-100.0f, 0.0f, 0.0f), new class_2379(-105.0f, 0.0f, 0.0f), new class_2379(-46.0f, 0.0f, 0.0f), new class_2379(7.0f, 0.0f, 0.0f)),
    SITTING("sitting", Source.VANILLA_TWEAKS, Category.SITTING, new class_2379(0.0f, 0.001f, 0.0f), new class_2379(0.0f, 0.001f, 0.0f), new class_2379(-80.0f, 20.0f, 0.0f), new class_2379(-80.0f, -20.0f, 0.0f), new class_2379(-90.0f, 10.0f, 0.0f), new class_2379(-90.0f, -10.0f, 0.0f)),
    LAZING("lazing", Source.VANILLA_TWEAKS, Category.SITTING, new class_2379(14.0f, -12.0f, 6.0f), new class_2379(5.0f, 0.0f, 0.0f), new class_2379(-40.0f, 20.0f, 0.0f), new class_2379(-4.0f, -20.0f, -10.0f), new class_2379(-88.0f, 71.0f, 0.0f), new class_2379(-88.0f, 46.0f, 0.0f)),
    JUMP_ATTACK("jumpAttack", Source.ROUNDAROUND, Category.DYNAMIC, new class_2379(-43.0f, 0.0f, 0.0f), new class_2379(4.0f, 0.0f, 0.0f), new class_2379(-144.0f, -10.0f, 28.0f), new class_2379(-129.0f, 47.0f, -7.0f), new class_2379(30.0f, 0.0f, 20.0f), new class_2379(30.0f, 0.0f, -20.0f)),
    STEWARD("steward", Source.ROUNDAROUND, Category.STANDING, new class_2379(-3.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, 2.0f), new class_2379(-105.0f, -45.0f, 180.0f), new class_2379(-2.0f, 0.0f, -20.0f), new class_2379(0.0f, 0.0f, 5.0f), new class_2379(0.0f, 0.0f, -5.0f)),
    SCARECROW("scarecrow", Source.ROUNDAROUND, Category.DYNAMIC, new class_2379(8.0f, 26.0f, -6.0f), new class_2379(0.0f, 0.0f, 5.0f), new class_2379(-15.0f, 0.0f, 79.0f), new class_2379(-16.0f, 0.0f, -40.0f), new class_2379(0.0f, 0.0f, -18.0f), new class_2379(16.0f, 20.0f, 0.0f)),
    PRETTY("pretty", Source.ROUNDAROUND, Category.SITTING, new class_2379(-17.0f, 0.0f, 0.0f), new class_2379(0.0f, 0.0f, -8.0f), new class_2379(-12.0f, 20.0f, 0.0f), new class_2379(130.0f, -14.0f, -3.0f), new class_2379(-100.0f, -44.0f, 0.0f), new class_2379(-90.0f, -10.0f, 0.0f)),
    DRUM_MAJOR("drumMajor", Source.ROUNDAROUND, Category.DYNAMIC, new class_2379(-13.0f, 0.0f, 0.0f), new class_2379(9.0f, 0.0f, 0.0f), new class_2379(110.0f, 125.0f, 180.0f), new class_2379(-10.0f, 0.0f, -20.0f), new class_2379(-94.0f, 0.0f, 0.0f), new class_2379(15.0f, 0.0f, 0.0f)),
    FISHING("fishing", Source.ROUNDAROUND, Category.SITTING, new class_2379(-15.0f, 0.0f, -12.0f), new class_2379(-8.0f, 0.0f, 0.0f), new class_2379(-68.0f, -24.0f, 0.0f), new class_2379(-80.0f, 44.0f, 0.0f), new class_2379(-90.0f, 20.0f, 0.0f), new class_2379(-90.0f, -20.0f, 0.0f));

    private final String id;
    private final class_2561 label;
    private final Source source;
    private final Category category;
    private final class_2379 head;
    private final class_2379 body;
    private final class_2379 rightArm;
    private final class_2379 leftArm;
    private final class_2379 rightLeg;
    private final class_2379 leftLeg;

    private PosePreset(String id, Source source, Category category, class_2379 head, class_2379 body, class_2379 rightArm, class_2379 leftArm, class_2379 rightLeg, class_2379 leftLeg) {
        this.id = id;
        this.label = class_2561.method_43471((String)("armorstands.preset." + id));
        this.source = source;
        this.category = category;
        this.head = head;
        this.body = body;
        this.rightArm = rightArm;
        this.leftArm = leftArm;
        this.rightLeg = rightLeg;
        this.leftLeg = leftLeg;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Pose toPose() {
        return new Pose(this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg);
    }

    public class_2561 getDisplayName() {
        return this.label;
    }

    public Source getSource() {
        return this.source;
    }

    public Category getCategory() {
        return this.category;
    }

    public class_2379 getHead() {
        return this.head;
    }

    public class_2379 getBody() {
        return this.body;
    }

    public class_2379 getRightArm() {
        return this.rightArm;
    }

    public class_2379 getLeftArm() {
        return this.leftArm;
    }

    public class_2379 getRightLeg() {
        return this.rightLeg;
    }

    public class_2379 getLeftLeg() {
        return this.leftLeg;
    }

    public static PosePreset fromString(String value) {
        return Arrays.stream(PosePreset.values()).filter(pose -> pose.id.equals(value)).findFirst().orElseGet(() -> {
            ArmorStandsMod.LOGGER.warn("Unknown id '{}'. Defaulting to DEFAULT.", (Object)Source.BEDROCK, (Object)value);
            return DEFAULT;
        });
    }

    public static List<PosePreset> getPresets() {
        return PosePreset.getPresets(Source.ALL, Category.ALL);
    }

    public static List<PosePreset> getPresets(Source source, Category category) {
        return Arrays.stream(PosePreset.values()).filter(pose -> pose.getSource().matches(source) && pose.getCategory().matches(category)).sorted((a, b) -> {
            if (category != Category.ALL) {
                int sourceCompare = a.getSource().compareTo(b.getSource());
                if (sourceCompare != 0) {
                    return sourceCompare;
                }
            } else {
                int categoryCompare = a.getCategory().compareTo(b.getCategory());
                if (categoryCompare != 0) {
                    return categoryCompare;
                }
            }
            return a.getDisplayName().getString().compareTo(b.getDisplayName().getString());
        }).collect(Collectors.toList());
    }

    public static enum Source {
        ALL("all"),
        VANILLA("vanilla"),
        VANILLA_TWEAKS("vanillaTweaks"),
        BEDROCK("bedrock"),
        ROUNDAROUND("roundaround");

        private final String id;

        private Source(String id) {
            this.id = id;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("armorstands.source." + this.id));
        }

        public boolean matches(Source source) {
            return this == ALL || source == ALL || this == source;
        }

        public static List<Source> getSources() {
            return Arrays.stream(Source.values()).filter(source -> source == ALL || Arrays.stream(PosePreset.values()).anyMatch(pose -> pose.getSource() == source)).collect(Collectors.toList());
        }
    }

    public static enum Category {
        ALL("all"),
        STANDING("standing"),
        MOVING("moving"),
        DYNAMIC("dynamic"),
        SITTING("sitting"),
        OTHER("other");

        private final String id;

        private Category(String id) {
            this.id = id;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("armorstands.category." + this.id));
        }

        public boolean matches(Category category) {
            return this == ALL || category == ALL || this == category;
        }

        public static List<Category> getCategories() {
            return Arrays.stream(Category.values()).filter(category -> category == ALL || Arrays.stream(PosePreset.values()).anyMatch(pose -> pose.getCategory() == category)).collect(Collectors.toList());
        }
    }
}

