/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.roundaround.armorstands.util.Pose;
import net.minecraft.class_2379;

public class SavedPose
implements Pose.PoseSupplier {
    private final String name;
    private final class_2379 head;
    private final class_2379 body;
    private final class_2379 rightArm;
    private final class_2379 leftArm;
    private final class_2379 rightLeg;
    private final class_2379 leftLeg;

    public SavedPose(String name, class_2379 head, class_2379 body, class_2379 rightArm, class_2379 leftArm, class_2379 rightLeg, class_2379 leftLeg) {
        this.name = name;
        this.head = head;
        this.body = body;
        this.rightArm = rightArm;
        this.leftArm = leftArm;
        this.rightLeg = rightLeg;
        this.leftLeg = leftLeg;
    }

    public SavedPose(String name, Pose pose) {
        this(name, pose.getHead(), pose.getBody(), pose.getRightArm(), pose.getLeftArm(), pose.getRightLeg(), pose.getLeftLeg());
    }

    @Override
    public Pose toPose() {
        return new Pose(this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftLeg);
    }

    public String getName() {
        return this.name;
    }

    public class_2379 getHead() {
        return this.head;
    }

    public class_2379 getBody() {
        return this.body;
    }

    public class_2379 getRightArm() {
        return this.rightArm;
    }

    public class_2379 getLeftArm() {
        return this.leftArm;
    }

    public class_2379 getRightLeg() {
        return this.rightLeg;
    }

    public class_2379 getLeftLeg() {
        return this.leftLeg;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.add("head", (JsonElement)SavedPose.eulerAngleToJson(this.head));
        json.add("body", (JsonElement)SavedPose.eulerAngleToJson(this.body));
        json.add("rightArm", (JsonElement)SavedPose.eulerAngleToJson(this.rightArm));
        json.add("leftArm", (JsonElement)SavedPose.eulerAngleToJson(this.leftArm));
        json.add("rightLeg", (JsonElement)SavedPose.eulerAngleToJson(this.rightLeg));
        json.add("leftLeg", (JsonElement)SavedPose.eulerAngleToJson(this.leftLeg));
        return json;
    }

    public static SavedPose fromJson(JsonObject json) {
        String name = json.get("name").getAsString();
        class_2379 head = SavedPose.jsonToEulerAngle(json.getAsJsonArray("head"));
        class_2379 body = SavedPose.jsonToEulerAngle(json.getAsJsonArray("body"));
        class_2379 rightArm = SavedPose.jsonToEulerAngle(json.getAsJsonArray("rightArm"));
        class_2379 leftArm = SavedPose.jsonToEulerAngle(json.getAsJsonArray("leftArm"));
        class_2379 rightLeg = SavedPose.jsonToEulerAngle(json.getAsJsonArray("rightLeg"));
        class_2379 leftLeg = SavedPose.jsonToEulerAngle(json.getAsJsonArray("leftLeg"));
        return new SavedPose(name, head, body, rightArm, leftArm, rightLeg, leftLeg);
    }

    private static class_2379 jsonToEulerAngle(JsonArray json) {
        float pitch = json.get(0).getAsFloat();
        float yaw = json.get(1).getAsFloat();
        float roll = json.get(2).getAsFloat();
        return new class_2379(pitch, yaw, roll);
    }

    private static JsonArray eulerAngleToJson(class_2379 angle) {
        JsonArray json = new JsonArray();
        json.add((Number)Float.valueOf(angle.method_10256()));
        json.add((Number)Float.valueOf(angle.method_10257()));
        json.add((Number)Float.valueOf(angle.method_10258()));
        return json;
    }
}

