/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util.actions;

import java.util.Optional;
import me.roundaround.armorstands.util.ArmorStandHelper;
import me.roundaround.armorstands.util.actions.ArmorStandAction;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class MoveAction
implements ArmorStandAction {
    private final class_243 argument;
    private final MoveType moveType;
    private final boolean roundToPixel;
    private final boolean localToPlayer;
    private Optional<class_243> originalPosition = Optional.empty();

    private MoveAction(class_243 argument, MoveType moveType, boolean roundToPixel, boolean localToPlayer) {
        this.argument = argument;
        this.moveType = moveType;
        this.roundToPixel = roundToPixel;
        this.localToPlayer = localToPlayer;
    }

    public static MoveAction absolute(class_243 position) {
        return new MoveAction(position, MoveType.ABSOLUTE, false, false);
    }

    public static MoveAction absolute(double x, double y, double z) {
        return MoveAction.absolute(new class_243(x, y, z));
    }

    public static MoveAction relative(class_243 position, boolean roundToPixel) {
        return new MoveAction(position, MoveType.RELATIVE, roundToPixel, false);
    }

    public static MoveAction relative(double x, double y, double z, boolean roundToPixel) {
        return MoveAction.relative(new class_243(x, y, z), roundToPixel);
    }

    public static MoveAction relative(class_243 position) {
        return MoveAction.relative(position, false);
    }

    public static MoveAction relative(double x, double y, double z) {
        return MoveAction.relative(x, y, z, false);
    }

    public static MoveAction local(class_243 position) {
        return new MoveAction(position, MoveType.LOCAL, false, false);
    }

    public static MoveAction local(double x, double y, double z) {
        return MoveAction.local(new class_243(x, y, z));
    }

    public static MoveAction local(class_243 position, boolean localToPlayer) {
        return new MoveAction(position, MoveType.LOCAL, false, localToPlayer);
    }

    public static MoveAction local(double x, double y, double z, boolean localToPlayer) {
        return MoveAction.local(new class_243(x, y, z), localToPlayer);
    }

    @Override
    public class_2561 getName(class_1531 armorStand) {
        return class_2561.method_43471((String)"armorstands.action.move");
    }

    @Override
    public void apply(class_1657 player, class_1531 armorStand) {
        class_243 position;
        this.originalPosition = Optional.of(armorStand.method_19538());
        switch (this.moveType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ABSOLUTE: {
                class_243 class_2432 = this.argument;
                break;
            }
            case RELATIVE: {
                class_243 class_2432 = this.originalPosition.get().method_1019(this.argument);
                break;
            }
            case LOCAL: {
                class_243 class_2432 = position = this.originalPosition.get().method_1019(ArmorStandHelper.localToRelative((class_1297)(this.localToPlayer ? player : armorStand), this.argument));
            }
        }
        if (this.roundToPixel) {
            double x = (double)Math.round(position.field_1352 * 16.0) / 16.0;
            double y = (double)Math.round(position.field_1351 * 16.0) / 16.0;
            double z = (double)Math.round(position.field_1350 * 16.0) / 16.0;
            position = new class_243(x, y, z);
        }
        MoveAction.setPosition(armorStand, position);
    }

    @Override
    public void undo(class_1657 player, class_1531 armorStand) {
        if (this.originalPosition.isEmpty()) {
            return;
        }
        MoveAction.setPosition(armorStand, this.originalPosition.get());
    }

    public static void setPosition(class_1531 armorStand, class_243 position) {
        MoveAction.setPosition(armorStand, position.field_1352, position.field_1351, position.field_1350);
    }

    public static void setPosition(class_1531 armorStand, double x, double y, double z) {
        boolean hasGravity = !armorStand.method_5740();
        double currY = armorStand.method_23318();
        if (hasGravity && Math.abs(y - currY) > (double)1.0E-5f) {
            y += 0.001;
        }
        armorStand.method_43391(x, y, z);
        armorStand.method_33574(new class_243(x, y, z));
    }

    public static enum MoveType {
        ABSOLUTE("absolute"),
        RELATIVE("relative"),
        LOCAL("local");

        private final String id;

        private MoveType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static MoveType fromId(String id) {
            for (MoveType type : MoveType.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return ABSOLUTE;
        }
    }
}

