/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util.actions;

import java.util.Optional;
import me.roundaround.armorstands.util.actions.ArmorStandAction;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public class RotateAction
implements ArmorStandAction {
    private final float argument;
    private final boolean absolute;
    private final boolean round;
    private Optional<Float> originalRotation = Optional.empty();

    private RotateAction(float argument, boolean absolute, boolean round) {
        this.argument = argument;
        this.absolute = absolute;
        this.round = round;
    }

    public static RotateAction absolute(float rotation) {
        return RotateAction.absolute(rotation, false);
    }

    public static RotateAction absolute(float rotation, boolean round) {
        return new RotateAction(rotation, true, round);
    }

    public static RotateAction relative(float rotation) {
        return RotateAction.relative(rotation, true);
    }

    public static RotateAction relative(float rotation, boolean round) {
        return new RotateAction(rotation, false, round);
    }

    @Override
    public class_2561 getName(class_1531 armorStand) {
        return class_2561.method_43471((String)"armorstands.action.rotate");
    }

    @Override
    public void apply(class_1657 player, class_1531 armorStand) {
        this.originalRotation = Optional.of(Float.valueOf(armorStand.method_36454()));
        float rotation = this.argument;
        if (!this.absolute) {
            rotation += this.originalRotation.get().floatValue();
        }
        RotateAction.setRotation(armorStand, rotation, this.round);
    }

    @Override
    public void undo(class_1657 player, class_1531 armorStand) {
        if (this.originalRotation.isEmpty()) {
            return;
        }
        RotateAction.setRotation(armorStand, this.originalRotation.get().floatValue());
    }

    public static void setRotation(class_1531 armorStand, float rotation) {
        RotateAction.setRotation(armorStand, rotation, false);
    }

    public static void setRotation(class_1531 armorStand, float rotation, boolean round) {
        float target = rotation % 360.0f;
        if (round) {
            target = Math.round(target);
        }
        armorStand.method_36456(target);
    }
}

