/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.data.ForgeBiomeTagProvider;
import com.grim3212.assorted.lib.data.ForgeBlockTagProvider;
import com.grim3212.assorted.lib.data.ForgeItemTagProvider;
import com.grim3212.assorted.lib.data.LibCommonTagProvider;
import com.grim3212.assorted.lib.events.AnvilUpdatedEvent;
import com.grim3212.assorted.lib.events.EntityInteractEvent;
import com.grim3212.assorted.lib.events.ForgeLootTableModificationContext;
import com.grim3212.assorted.lib.events.LootTableModifyEvent;
import com.grim3212.assorted.lib.events.UseBlockEvent;
import com.grim3212.assorted.lib.platform.ForgePlatformHelper;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.worldgen.LibForgeWorldGen;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="assortedlib")
public class AssortedLibForge {
    public AssortedLibForge() {
        LibConstants.LOG.info("Assorted Lib starting up...");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::gatherData);
        modBus.addListener(this::registerRecipeSerializers);
        modBus.addListener(this::registerCreativeTabs);
        Services.EVENTS.registerEventType(UseBlockEvent.class, () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, event -> {
            UseBlockEvent newEvent = new UseBlockEvent(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            Services.EVENTS.handleEvents(newEvent);
            if (newEvent.isCanceled()) {
                event.setCancellationResult(newEvent.getInteractionResult());
                event.setCanceled(true);
            }
        }));
        Services.EVENTS.registerEventType(AnvilUpdatedEvent.class, () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, event -> {
            AnvilUpdatedEvent newEvent = new AnvilUpdatedEvent(event.getLeft(), event.getRight(), event.getName(), event.getCost(), event.getPlayer());
            Services.EVENTS.handleEvents(newEvent);
            if (newEvent.isCanceled()) {
                event.setCanceled(true);
            } else if (!newEvent.getOutput().m_41619_()) {
                event.setOutput(newEvent.getOutput());
                event.setCost(newEvent.getCost());
                event.setMaterialCost(newEvent.getMaterialCost());
            }
        }));
        Services.EVENTS.registerEventType(EntityInteractEvent.class, () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, event -> {
            EntityInteractEvent newEvent = new EntityInteractEvent(event.getEntity(), event.getHand(), event.getTarget());
            Services.EVENTS.handleEvents(newEvent);
            event.setCanceled(newEvent.isCanceled());
            event.setCancellationResult(newEvent.getInteractionResult());
        }));
        Services.EVENTS.registerEventType(LootTableModifyEvent.class, () -> MinecraftForge.EVENT_BUS.addListener(event -> {
            LootTableModifyEvent newEvent = new LootTableModifyEvent(event.getLootTableManager(), event.getName(), new ForgeLootTableModificationContext(event.getTable()), true);
            Services.EVENTS.handleEvents(newEvent);
        }));
        Services.CONDITIONS.init();
        LibForgeWorldGen.init(modBus);
    }

    private void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            Services.INGREDIENTS.register();
        }
    }

    private void registerCreativeTabs(CreativeModeTabEvent.Register event) {
        for (ForgePlatformHelper.TabRegister tab : ForgePlatformHelper.tabsToRegister.values()) {
            event.registerCreativeModeTab(tab.id(), builder -> builder.m_257941_(tab.title()).m_257737_(tab.icon()).m_257501_((enabledFlags, populator, hasPermissions) -> populator.m_246601_((Collection)tab.displayStacks().get())));
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        PackOutput packOutput = datagenerator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ForgeBlockTagProvider blockTagProvider = new ForgeBlockTagProvider(packOutput, lookupProvider, fileHelper, "assortedlib", new LibCommonTagProvider.BlockTagProvider(packOutput, lookupProvider));
        datagenerator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        datagenerator.addProvider(event.includeServer(), (DataProvider)new ForgeItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTagProvider, fileHelper, "assortedlib", new LibCommonTagProvider.ItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTagProvider)));
        datagenerator.addProvider(event.includeServer(), (DataProvider)new ForgeBiomeTagProvider(packOutput, lookupProvider, fileHelper, "assortedlib", new LibCommonTagProvider.BiomeTagProvider(packOutput, lookupProvider)));
    }
}

