/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.grim3212.assorted.lib.client.model.IModelBuilder;
import com.grim3212.assorted.lib.client.model.RenderTypeGroup;
import com.grim3212.assorted.lib.client.model.baked.IDataAwareBakedModel;
import com.grim3212.assorted.lib.client.model.baked.IDelegatingBakedModel;
import com.grim3212.assorted.lib.client.model.data.IBlockModelData;
import com.grim3212.assorted.lib.client.model.data.IModelDataKey;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecification;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecificationLoader;
import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import com.grim3212.assorted.lib.platform.ClientServices;
import com.grim3212.assorted.lib.util.ConcatenatedListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombiningModel
implements IModelSpecification<CombiningModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<String, BlockModel> children;
    private final boolean logWarning;

    public CombiningModel(ImmutableMap<String, BlockModel> children) {
        this(children, false);
    }

    private CombiningModel(ImmutableMap<String, BlockModel> children, boolean logWarning) {
        this.children = children;
        this.logWarning = logWarning;
    }

    @Override
    public BakedModel bake(IModelBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"parts\" field in its composite model instead of \"children\". This field will be removed in 1.20.");
        }
        Material particleLocation = context.getMaterial("particle").orElse(null);
        TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            BlockModel model = (BlockModel)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.m_111449_(bakery, model, spriteGetter, modelTransform, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), context.getItemOverrides(bakery), (ImmutableMap<String, BakedModel>)bakedParts);
    }

    public static class Baked
    implements IDataAwareBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private final ImmutableMap<String, BakedModel> children;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, BakedModel> children) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
        }

        @NotNull
        private static Collection<RenderType> getRenderTypes(BakedModel model, BlockState state, RandomSource rand, IBlockModelData data) {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getSupportedRenderTypes(state, rand, data);
            }
            if (model instanceof IDelegatingBakedModel) {
                IDelegatingBakedModel delegatingBakedModel = (IDelegatingBakedModel)model;
                return Baked.getRenderTypes(delegatingBakedModel.getDelegate(), state, rand, data);
            }
            return ClientServices.MODELS.getRenderTypesFor(model, state, rand, data);
        }

        @NotNull
        private static Collection<RenderType> getRenderTypes(BakedModel model, ItemStack stack, Boolean fabulous) {
            if (model instanceof IDataAwareBakedModel) {
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)model;
                return dataAwareBakedModel.getSupportedRenderTypes(stack, fabulous);
            }
            if (model instanceof IDelegatingBakedModel) {
                IDelegatingBakedModel delegatingBakedModel = (IDelegatingBakedModel)model;
                return Baked.getRenderTypes(delegatingBakedModel.getDelegate(), stack, fabulous);
            }
            return ClientServices.MODELS.getRenderTypesFor(model, stack, fabulous);
        }

        public static Builder builder(IModelBakingContext owner, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms cameraTransforms) {
            return Baked.builder(owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), particle, overrides, cameraTransforms);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, overrides, cameraTransforms);
        }

        @Override
        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull IBlockModelData extraData, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (state == null || !Baked.getRenderTypes((BakedModel)entry.getValue(), state, rand, extraData).contains(renderType))) continue;
                Object v = entry.getValue();
                if (v instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                    quadLists.add(dataAwareBakedModel.getQuads(state, side, rand, Data.resolve(extraData, (String)entry.getKey()), renderType));
                    continue;
                }
                quadLists.add(((BakedModel)entry.getValue()).m_213637_(state, side, rand));
            }
            return ConcatenatedListView.of(quadLists);
        }

        @Override
        @NotNull
        public List<BakedQuad> getQuads(ItemStack stack, boolean fabulous, @NotNull RandomSource rand, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (stack == null || !Baked.getRenderTypes((BakedModel)entry.getValue(), stack, fabulous).contains(renderType))) continue;
                Object v = entry.getValue();
                if (v instanceof IDataAwareBakedModel) {
                    IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                    quadLists.add(dataAwareBakedModel.getQuads(stack, fabulous, rand, renderType));
                    continue;
                }
                quadLists.add(((BakedModel)entry.getValue()).m_213637_(null, null, rand));
            }
            return ConcatenatedListView.of(quadLists);
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        @NotNull
        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        @NotNull
        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        @NotNull
        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        @Override
        @NotNull
        public Collection<RenderType> getSupportedRenderTypes(BlockState state, RandomSource rand, IBlockModelData data) {
            ArrayList<Collection<RenderType>> sets = new ArrayList<Collection<RenderType>>();
            for (Map.Entry entry : this.children.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IDataAwareBakedModel)) continue;
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                sets.add(dataAwareBakedModel.getSupportedRenderTypes(state, rand, Data.resolve(data, (String)entry.getKey())));
            }
            return sets.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public Collection<RenderType> getSupportedRenderTypes(ItemStack stack, boolean fabulous) {
            ArrayList<Collection<RenderType>> sets = new ArrayList<Collection<RenderType>>();
            for (Map.Entry entry : this.children.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IDataAwareBakedModel)) continue;
                IDataAwareBakedModel dataAwareBakedModel = (IDataAwareBakedModel)v;
                sets.add(dataAwareBakedModel.getSupportedRenderTypes(stack, fabulous));
            }
            return sets.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @NotNull
        public List<BakedQuad> m_213637_(@Nullable BlockState pState, @Nullable Direction pDirection, @NotNull RandomSource pRandom) {
            return this.getQuads(pState, pDirection, pRandom, IBlockModelData.empty(), null);
        }

        @Nullable
        public BakedModel getPart(String name) {
            return (BakedModel)this.children.get((Object)name);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final List<BakedModel> children = new ArrayList<BakedModel>();
            private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
            private final ItemOverrides overrides;
            private final ItemTransforms transforms;
            private TextureAtlasSprite particle;
            private RenderTypeGroup lastRenderTypes = RenderTypeGroup.EMPTY;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
            }

            public void addLayer(BakedModel model) {
                this.flushQuads(null);
                this.children.add(model);
            }

            private void addLayer(RenderTypeGroup renderTypes, List<BakedQuad> quads) {
                IModelBuilder<?> modelBuilder = IModelBuilder.of(this.isAmbientOcclusion, this.isSideLit, this.isGui3d, this.transforms, this.overrides, this.particle, renderTypes);
                quads.forEach(modelBuilder::addUnculledFace);
                this.children.add(modelBuilder.build());
            }

            private void flushQuads(RenderTypeGroup renderTypes) {
                if (!Objects.equals(renderTypes, this.lastRenderTypes)) {
                    if (this.quads.size() > 0) {
                        this.addLayer(this.lastRenderTypes, this.quads);
                        this.quads.clear();
                    }
                    this.lastRenderTypes = renderTypes;
                }
            }

            public Builder setParticle(TextureAtlasSprite particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, BakedQuad ... quadsToAdd) {
                this.flushQuads(renderTypes);
                Collections.addAll(this.quads, quadsToAdd);
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, Collection<BakedQuad> quadsToAdd) {
                this.flushQuads(renderTypes);
                this.quads.addAll(quadsToAdd);
                return this;
            }

            public BakedModel build() {
                if (this.quads.size() > 0) {
                    this.addLayer(this.lastRenderTypes, this.quads);
                }
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                int i = 0;
                for (BakedModel model : this.children) {
                    childrenBuilder.put((Object)("model_" + i++), (Object)model);
                }
                return new Baked(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, BakedModel>)childrenBuilder.build());
            }
        }
    }

    public static final class Loader
    implements IModelSpecificationLoader<CombiningModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public CombiningModel read(JsonDeserializationContext deserializationContext, JsonObject jsonObject) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder, false);
            boolean logWarning = this.readChildren(jsonObject, "parts", deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder, true);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            return new CombiningModel((ImmutableMap<String, BlockModel>)children, logWarning);
        }

        private boolean readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, BlockModel> children, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((BlockModel)deserializationContext.deserialize((JsonElement)entry.getValue(), BlockModel.class)));
            }
            return logWarning;
        }
    }

    public static class Data {
        public static final IModelDataKey<Data> PROPERTY = IModelDataKey.create();
        private final Map<String, IBlockModelData> partData;

        private Data(Map<String, IBlockModelData> partData) {
            this.partData = partData;
        }

        public static IBlockModelData resolve(IBlockModelData modelData, String name) {
            Data compositeData = modelData.getData(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            IBlockModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Nullable
        public IBlockModelData get(String name) {
            return this.partData.get(name);
        }

        public static final class Builder {
            private final Map<String, IBlockModelData> partData = new IdentityHashMap<String, IBlockModelData>();

            public Builder with(String name, IBlockModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

