/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model;

import com.grim3212.assorted.lib.client.model.EmptyModel;
import com.grim3212.assorted.lib.client.model.RenderTypeGroup;
import com.grim3212.assorted.lib.client.model.baked.simple.WrappedSimpleBakedModel;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;

public interface IModelBuilder<T extends IModelBuilder<T>> {
    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, ItemOverrides overrides, TextureAtlasSprite particle, RenderTypeGroup renderTypes) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides, particle, renderTypes);
    }

    public static IModelBuilder<?> collecting(List<BakedQuad> quads) {
        return new Collecting(quads);
    }

    public T addCulledFace(Direction var1, BakedQuad var2);

    public T addUnculledFace(BakedQuad var1);

    public BakedModel build();

    public static class Simple
    implements IModelBuilder<Simple> {
        private final WrappedSimpleBakedModel.Builder builder;
        private final RenderTypeGroup renderTypes;

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, ItemOverrides overrides, TextureAtlasSprite particle, RenderTypeGroup renderTypes) {
            this.builder = new WrappedSimpleBakedModel.Builder(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, overrides).particle(particle);
            this.renderTypes = renderTypes;
        }

        @Override
        public Simple addCulledFace(Direction facing, BakedQuad quad) {
            this.builder.addCulledFace(facing, quad);
            return this;
        }

        @Override
        public Simple addUnculledFace(BakedQuad quad) {
            this.builder.addUnculledFace(quad);
            return this;
        }

        @Override
        @Deprecated
        public BakedModel build() {
            return this.builder.build(this.renderTypes);
        }
    }

    public static class Collecting
    implements IModelBuilder<Collecting> {
        private final List<BakedQuad> quads;

        private Collecting(List<BakedQuad> quads) {
            this.quads = quads;
        }

        @Override
        public Collecting addCulledFace(Direction facing, BakedQuad quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public Collecting addUnculledFace(BakedQuad quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public BakedModel build() {
            return EmptyModel.BAKED;
        }
    }
}

