/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model;

import com.google.common.collect.ImmutableMap;
import com.grim3212.assorted.lib.mixin.client.AccessorBlockModel;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;

public class RetexturableBlockModel
extends BlockModel {
    private final Map<String, Material> replacements = new HashMap<String, Material>();

    public static RetexturableBlockModel from(BlockModel parent, ResourceLocation parentLocation) {
        RetexturableBlockModel model = new RetexturableBlockModel(parentLocation, parent.m_111436_(), ((AccessorBlockModel)parent).assortedlib_getTextureMap(), parent.m_111476_(), parent.m_111479_(), parent.m_111491_(), parent.m_111484_());
        return model;
    }

    public RetexturableBlockModel(ResourceLocation parentLocation, List<BlockElement> elements, Map<String, Either<Material, String>> textures, boolean ambientOcclusion, BlockModel.GuiLight guiLight, ItemTransforms cameraTransforms, List<ItemOverride> overrides) {
        super(parentLocation, elements, textures, ambientOcclusion, guiLight, cameraTransforms, overrides);
    }

    public Material m_111480_(String nameIn) {
        if (this.replacements.containsKey(nameIn)) {
            return this.replacements.get(nameIn);
        }
        return super.m_111480_(nameIn);
    }

    public void replaceTexture(String name, ResourceLocation texture) {
        this.replacements.put(name, new Material(TextureAtlas.f_118259_, texture));
    }

    public RetexturableBlockModel retexture(ImmutableMap<String, String> textures) {
        textures.forEach((name, texture) -> this.replaceTexture((String)name, new ResourceLocation(texture)));
        return this;
    }
}

