/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.baked.simple;

import com.grim3212.assorted.lib.client.model.vertices.IVertexConsumer;
import com.grim3212.assorted.lib.client.util.LightUtil;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SimpleGeneratedModel
implements BakedModel {
    private final List<BakedQuad>[] face = new List[6];
    private final TextureAtlasSprite texture;

    public SimpleGeneratedModel(TextureAtlasSprite texture) {
        this.face[0] = new ArrayList<BakedQuad>();
        this.face[1] = new ArrayList<BakedQuad>();
        this.face[2] = new ArrayList<BakedQuad>();
        this.face[3] = new ArrayList<BakedQuad>();
        this.face[4] = new ArrayList<BakedQuad>();
        this.face[5] = new ArrayList<BakedQuad>();
        this.texture = texture;
        float[] afloat = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        BlockFaceUV uv = new BlockFaceUV(afloat, 0);
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        BlockModelRotation mr = BlockModelRotation.X0_Y0;
        for (Direction side : Direction.values()) {
            Vector3f toB;
            BlockElementFace bpf = new BlockElementFace(side, 1, "", uv);
            BakedQuad g = faceBakery.m_111600_(toB, switch (side) {
                case Direction.UP -> {
                    toB = new Vector3f(to.x(), from.y(), to.z());
                    yield new Vector3f(from.x(), from.y(), from.z());
                }
                case Direction.EAST -> {
                    toB = new Vector3f(from.x(), to.y(), to.z());
                    yield new Vector3f(from.x(), from.y(), from.z());
                }
                case Direction.NORTH -> {
                    toB = new Vector3f(to.x(), to.y(), to.z());
                    yield new Vector3f(from.x(), from.y(), to.z());
                }
                case Direction.SOUTH -> {
                    toB = new Vector3f(to.x(), to.y(), from.z());
                    yield new Vector3f(from.x(), from.y(), from.z());
                }
                case Direction.DOWN -> {
                    toB = new Vector3f(to.x(), to.y(), to.z());
                    yield new Vector3f(from.x(), to.y(), from.z());
                }
                case Direction.WEST -> {
                    toB = new Vector3f(to.x(), to.y(), to.z());
                    yield new Vector3f(to.x(), from.y(), from.z());
                }
                default -> throw new NullPointerException();
            }, bpf, texture, side, (ModelState)mr, null, false, new ResourceLocation("scena", "simple"));
            this.face[side.ordinal()].add(this.finishFace(g, side));
        }
    }

    private BakedQuad finishFace(BakedQuad g, Direction myFace) {
        int[] vertData = g.m_111303_();
        int wrapAt = vertData.length / 4;
        BakedQuadBuilder b = new BakedQuadBuilder(g.m_173410_());
        b.setQuadOrientation(myFace);
        b.setQuadTint(1);
        for (int vertNum = 0; vertNum < 4; ++vertNum) {
            block7: for (int elementIndex = 0; elementIndex < DefaultVertexFormat.f_85811_.m_86023_().size(); ++elementIndex) {
                VertexFormatElement element = (VertexFormatElement)DefaultVertexFormat.f_85811_.m_86023_().get(elementIndex);
                switch (element.m_86048_()) {
                    case POSITION: {
                        b.put(vertNum, elementIndex, Float.intBitsToFloat(vertData[wrapAt * vertNum]), Float.intBitsToFloat(vertData[1 + wrapAt * vertNum]), Float.intBitsToFloat(vertData[2 + wrapAt * vertNum]));
                        continue block7;
                    }
                    case COLOR: {
                        float light = LightUtil.diffuseLight(myFace);
                        b.put(vertNum, elementIndex, light, light, light, 1.0f);
                        continue block7;
                    }
                    case NORMAL: {
                        b.put(vertNum, elementIndex, myFace.m_122429_(), myFace.m_122430_(), myFace.m_122431_());
                        continue block7;
                    }
                    case UV: {
                        if (element.m_86049_() == 1) {
                            b.put(vertNum, elementIndex, 0.0f, 0.0f);
                            continue block7;
                        }
                        float u = Float.intBitsToFloat(vertData[4 + wrapAt * vertNum]);
                        float v = Float.intBitsToFloat(vertData[5 + wrapAt * vertNum]);
                        b.put(vertNum, elementIndex, u, v);
                        continue block7;
                    }
                    default: {
                        b.put(vertNum, elementIndex, new float[0]);
                    }
                }
            }
        }
        b.onComplete();
        return b.build();
    }

    public List<BakedQuad>[] getFace() {
        return this.face;
    }

    @NotNull
    public List<BakedQuad> m_213637_(BlockState state, Direction side, @NotNull RandomSource rand) {
        if (side == null) {
            return Collections.emptyList();
        }
        return this.face[side.ordinal()];
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.texture;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static final class BakedQuadBuilder
    implements IVertexConsumer {
        private static final int SIZE = DefaultVertexFormat.f_85811_.m_86023_().size();
        private final float[][][] unpackedData = new float[4][SIZE][4];
        private int tint = -1;
        private Direction orientation;
        private TextureAtlasSprite texture;
        private boolean applyDiffuseLighting = true;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;

        public BakedQuadBuilder(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public VertexFormat getVertexFormat() {
            return DefaultVertexFormat.f_85811_;
        }

        @Override
        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        @Override
        public void setQuadOrientation(Direction orientation) {
            this.orientation = orientation;
        }

        @Override
        public void setTexture(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        @Override
        public void put(int vertexIndex, int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == SIZE) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public BakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            if (this.texture == null) {
                throw new IllegalStateException("texture not set");
            }
            int[] packed = new int[DefaultVertexFormat.f_85811_.m_86017_() * 4];
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < SIZE; ++e) {
                    LightUtil.pack(this.unpackedData[v][e], packed, DefaultVertexFormat.f_85811_, v, e);
                }
            }
            return new BakedQuad(packed, this.tint, this.orientation, this.texture, this.applyDiffuseLighting);
        }
    }
}

