/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.loader;

import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.BlockGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class ForgeModelBakingContextDelegate
implements IModelBakingContext {
    private final Function<ResourceLocation, UnbakedModel> unbakedModelGetter;
    private final IGeometryBakingContext delegate;

    public ForgeModelBakingContextDelegate(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, IGeometryBakingContext delegate) {
        this.unbakedModelGetter = unbakedModelGetter;
        this.delegate = delegate;
    }

    @Override
    public UnbakedModel getUnbakedModel(ResourceLocation unbakedModel) {
        return this.unbakedModelGetter.apply(unbakedModel);
    }

    @Override
    public Optional<Material> getMaterial(String name) {
        if (this.delegate.hasMaterial(name)) {
            return Optional.of(this.delegate.getMaterial(name));
        }
        return Optional.empty();
    }

    @Override
    public boolean isGui3d() {
        return this.delegate.isGui3d();
    }

    @Override
    public boolean useBlockLight() {
        return this.delegate.useBlockLight();
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.delegate.useAmbientOcclusion();
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.delegate.getTransforms();
    }

    @Override
    public ItemOverrides getItemOverrides(ModelBaker modelBaker) {
        IGeometryBakingContext iGeometryBakingContext = this.delegate;
        if (iGeometryBakingContext instanceof BlockGeometryBakingContext) {
            BlockGeometryBakingContext geometryBakingContext = (BlockGeometryBakingContext)iGeometryBakingContext;
            return geometryBakingContext.owner.getOverrides(modelBaker, geometryBakingContext.owner, material -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(material.m_119193_()).apply(material.m_119203_()));
        }
        return ItemOverrides.f_111734_;
    }
}

