/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.model.loaders.context;

import com.google.common.collect.Maps;
import com.grim3212.assorted.lib.client.model.loaders.context.IModelBakingContext;
import com.grim3212.assorted.lib.platform.ClientServices;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public class SimpleModelBakingContext
implements IModelBakingContext {
    private final Map<String, Material> materials;
    private final boolean isGui3d;
    private final boolean useBlockLight;
    private final boolean useAmbientOcclusion;
    private final ItemTransforms itemTransforms;
    private final ItemOverrides itemOverrides;

    public SimpleModelBakingContext(Map<String, Material> materials, boolean isGui3d, boolean useBlockLight, boolean useAmbientOcclusion, ItemTransforms itemTransforms, ItemOverrides itemOverrides) {
        this.materials = materials;
        this.isGui3d = isGui3d;
        this.useBlockLight = useBlockLight;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.itemTransforms = itemTransforms;
        this.itemOverrides = itemOverrides;
    }

    @Override
    public UnbakedModel getUnbakedModel(ResourceLocation unbakedModel) {
        return ClientServices.MODELS.getUnbakedModel(unbakedModel);
    }

    @Override
    public Optional<Material> getMaterial(String name) {
        return Optional.ofNullable(this.materials.get(name));
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.useBlockLight;
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.itemTransforms;
    }

    @Override
    public ItemOverrides getItemOverrides(ModelBaker baker) {
        return this.itemOverrides;
    }

    public static final class SimpleModelBakingContextBuilder {
        private final Map<String, Material> materials = Maps.newHashMap();
        private boolean isGui3d = false;
        private boolean useBlockLight = false;
        private boolean useAmbientOcclusion = false;
        private ItemTransforms itemTransforms = ItemTransforms.f_111786_;
        private ItemOverrides itemOverrides = ItemOverrides.f_111734_;

        private SimpleModelBakingContextBuilder() {
        }

        public static SimpleModelBakingContextBuilder builder() {
            return new SimpleModelBakingContextBuilder();
        }

        public SimpleModelBakingContextBuilder withMaterial(String name, Material material) {
            this.materials.put(name, material);
            return this;
        }

        public SimpleModelBakingContextBuilder withMaterials(Map<String, Material> materials) {
            this.materials.putAll(materials);
            return this;
        }

        public SimpleModelBakingContextBuilder withIsGui3d(boolean isGui3d) {
            this.isGui3d = isGui3d;
            return this;
        }

        public SimpleModelBakingContextBuilder withUseBlockLight(boolean useBlockLight) {
            this.useBlockLight = useBlockLight;
            return this;
        }

        public SimpleModelBakingContextBuilder withUseAmbientOcclusion(boolean useAmbientOcclusion) {
            this.useAmbientOcclusion = useAmbientOcclusion;
            return this;
        }

        public SimpleModelBakingContextBuilder withItemTransforms(ItemTransforms itemTransforms) {
            this.itemTransforms = itemTransforms;
            return this;
        }

        public SimpleModelBakingContextBuilder withItemOverrides(ItemOverrides itemOverrides) {
            this.itemOverrides = itemOverrides;
            return this;
        }

        public SimpleModelBakingContextBuilder but() {
            return SimpleModelBakingContextBuilder.builder().withMaterials(this.materials).withIsGui3d(this.isGui3d).withUseBlockLight(this.useBlockLight).withUseAmbientOcclusion(this.useAmbientOcclusion).withItemTransforms(this.itemTransforms).withItemOverrides(this.itemOverrides);
        }

        public SimpleModelBakingContext build() {
            return new SimpleModelBakingContext(this.materials, this.isGui3d, this.useBlockLight, this.useAmbientOcclusion, this.itemTransforms, this.itemOverrides);
        }
    }
}

