/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.client.util;

import com.grim3212.assorted.lib.client.model.vertices.IVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public final class LightUtil {
    private LightUtil() {
        throw new IllegalStateException("Tried to construct a LightUtil instance, but this is a utility class!");
    }

    public static void pack(float[] from, int[] to, VertexFormat formatTo, int v, int e) {
        VertexFormatElement element = (VertexFormatElement)formatTo.m_86023_().get(e);
        int vertexStart = v * formatTo.m_86020_() + formatTo.f_86013_.getInt(e);
        int count = element.m_166969_();
        VertexFormatElement.Type type = element.m_86041_();
        int size = type.m_86074_();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == VertexFormatElement.Type.FLOAT ? Float.floatToRawIntBits(f) : (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT || type == VertexFormatElement.Type.UINT ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static void put(IVertexConsumer consumer, BakedQuad quad) {
        consumer.setTexture(quad.m_173410_());
        consumer.setQuadOrientation(quad.m_111306_());
        if (quad.m_111304_()) {
            consumer.setQuadTint(quad.m_111305_());
        }
        consumer.setApplyDiffuseLighting(quad.m_111307_());
        float[] data = new float[4];
        VertexFormat format = DefaultVertexFormat.f_85811_;
        int elementCount = format.m_86023_().size();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < elementCount; ++e) {
                LightUtil.unpack(quad.m_111303_(), data, format, v, e);
                consumer.put(v, e, data);
            }
        }
        consumer.onComplete();
    }

    public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = Math.min(4, to.length);
        VertexFormatElement element = (VertexFormatElement)formatFrom.m_86023_().get(e);
        int vertexStart = v * formatFrom.m_86020_() + formatFrom.f_86013_.getInt(e);
        int count = element.m_166969_();
        VertexFormatElement.Type type = element.m_86041_();
        VertexFormatElement.Usage usage = element.m_86048_();
        int size = type.m_86074_();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.Type.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.Type.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.Type.BYTE) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == VertexFormatElement.Type.SHORT) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != VertexFormatElement.Type.INT) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = i == 3 && usage == VertexFormatElement.Usage.POSITION ? 1.0f : 0.0f;
        }
    }

    public static float diffuseLight(Direction side) {
        return switch (side) {
            case Direction.DOWN -> 0.5f;
            case Direction.UP -> 1.0f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            default -> 0.6f;
        };
    }
}

