/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.conditions;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockExistsCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("assortedlib", "block_exists");
    private final ResourceLocation block;

    public BlockExistsCondition(ResourceLocation block) {
        this.block = block;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return ForgeRegistries.BLOCKS.containsKey(this.block);
    }

    public String toString() {
        return "block_exists(\"" + this.block + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<BlockExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, BlockExistsCondition value) {
            json.addProperty("block", value.block.toString());
        }

        public BlockExistsCondition read(JsonObject json) {
            return new BlockExistsCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

