/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.conditions;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public abstract class TagPopulatedCondition<T>
implements ICondition {
    private final ResourceKey<? extends Registry<T>> registry;
    private final TagKey<T> tag;

    public TagPopulatedCondition(ResourceKey<? extends Registry<T>> registry, ResourceLocation tag) {
        this.tag = TagKey.m_203882_(registry, (ResourceLocation)tag);
        this.registry = registry;
    }

    public boolean test(ICondition.IContext context) {
        return !context.getTag(this.tag).isEmpty();
    }

    public String toString() {
        return this.tag.f_203867_().m_211136_() + "_tag_populated(\"" + this.tag + "\")";
    }

    public static class BlockTagPopulatedCondition
    extends TagPopulatedCondition<Block> {
        public static final ResourceLocation NAME = new ResourceLocation("assortedlib", "block_tag_populated");
        public static Serializer<Block> SERIALIZER = new Serializer(NAME, BlockTagPopulatedCondition::new);

        public BlockTagPopulatedCondition(ResourceLocation tag) {
            super(Registries.f_256747_, tag);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }

    public static class ItemTagPopulatedCondition
    extends TagPopulatedCondition<Item> {
        public static final ResourceLocation NAME = new ResourceLocation("assortedlib", "item_tag_populated");
        public static Serializer<Item> SERIALIZER = new Serializer(NAME, ItemTagPopulatedCondition::new);

        public ItemTagPopulatedCondition(ResourceLocation tag) {
            super(Registries.f_256913_, tag);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }

    public record Serializer<T>(ResourceLocation name, Function<ResourceLocation, TagPopulatedCondition<T>> factory) implements IConditionSerializer<TagPopulatedCondition<T>>
    {
        public void write(JsonObject json, TagPopulatedCondition value) {
            json.addProperty("tag", value.tag.f_203868_().toString());
        }

        public TagPopulatedCondition<T> read(JsonObject json) {
            return this.factory.apply(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag")));
        }

        public ResourceLocation getID() {
            return this.name;
        }
    }
}

