/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.config;

import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeDelegateConfigurationBuilder
implements IConfigurationBuilder {
    private final Consumer<ForgeConfigSpec> specConsumer;
    private final ForgeConfigSpec.Builder builder;

    public ForgeDelegateConfigurationBuilder(Consumer<ForgeConfigSpec> specConsumer) {
        this.specConsumer = specConsumer;
        this.builder = new ForgeConfigSpec.Builder();
    }

    @Override
    public Supplier<Boolean> defineBoolean(String key, boolean defaultValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.BooleanValue)this.builder.define(key, defaultValue)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String key, List<T> defaultValue, Class<T> containedType, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.defineList(key, defaultValue, t -> true)).get();
    }

    @Override
    public Supplier<String> defineString(String key, String defaultValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.define(key, (Object)defaultValue)).get();
    }

    @Override
    public Supplier<Long> defineLong(String key, long defaultValue, long minValue, long maxValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.LongValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Integer> defineInteger(String key, int defaultValue, int minValue, int maxValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.IntValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Double> defineDouble(String key, double defaultValue, double minValue, double maxValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.DoubleValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public <T extends Enum<T>> Supplier<T> defineEnum(String key, T defaultValue, String comment) {
        this.builder.comment(comment);
        return () -> ((ForgeConfigSpec.EnumValue)this.builder.defineEnum(key, defaultValue)).get();
    }

    @Override
    public void setup() {
        this.specConsumer.accept(this.builder.build());
    }
}

