/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.conditions;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.core.conditions.LibConditionProvider;
import com.grim3212.assorted.lib.platform.Services;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public abstract class ConditionalRecipeProvider
extends RecipeProvider {
    protected final Map<ResourceLocation, List<LibConditionProvider>> conditions;
    protected final PackOutput.PathProvider f_236355_;
    protected final PackOutput.PathProvider f_236356_;
    private final String modId;

    public ConditionalRecipeProvider(PackOutput output, String modId) {
        super(output);
        this.modId = modId;
        this.conditions = new HashMap<ResourceLocation, List<LibConditionProvider>>();
        this.f_236355_ = output.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.f_236356_ = output.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    public LibConditionProvider and(LibConditionProvider ... providers) {
        return Services.CONDITIONS.and(providers);
    }

    public LibConditionProvider or(LibConditionProvider ... providers) {
        return Services.CONDITIONS.or(providers);
    }

    public LibConditionProvider not(LibConditionProvider provider) {
        return Services.CONDITIONS.not(provider);
    }

    public LibConditionProvider itemTagExists(TagKey<Item> itemTag) {
        return Services.CONDITIONS.itemTagExists(itemTag);
    }

    public LibConditionProvider modLoaded(String modId) {
        return Services.CONDITIONS.modLoaded(modId);
    }

    public LibConditionProvider partEnabled(String part) {
        return Services.CONDITIONS.partEnabled(part);
    }

    public Ingredient and(Ingredient ... ingredients) {
        return Services.INGREDIENTS.and(ingredients);
    }

    public Ingredient or(Ingredient ... ingredients) {
        return Services.INGREDIENTS.or(ingredients);
    }

    public Ingredient difference(Ingredient base, Ingredient subtracted) {
        return Services.INGREDIENTS.difference(base, subtracted);
    }

    public Ingredient nbt(ItemStack item) {
        return Services.INGREDIENTS.nbt(item);
    }

    public Ingredient fluid(@Nullable TagKey<Item> itemTagKey, TagKey<Fluid> fluidTagKey, long amount) {
        return Services.INGREDIENTS.fluid(itemTagKey, fluidTagKey, amount);
    }

    public Ingredient fluid(TagKey<Fluid> fluidTagKey) {
        return Services.INGREDIENTS.fluid(null, fluidTagKey, Services.FLUIDS.getBucketAmount());
    }

    protected String name(Item i) {
        return this.id(i).m_135815_();
    }

    protected String name(Block b) {
        return this.id(b).m_135815_();
    }

    protected ResourceLocation id(Item i) {
        return Services.PLATFORM.getRegistry(Registries.f_256913_).getRegistryName(i);
    }

    protected ResourceLocation id(Block b) {
        return Services.PLATFORM.getRegistry(Registries.f_256747_).getRegistryName(b);
    }

    protected ResourceLocation prefix(String name) {
        return new ResourceLocation(this.modId, name);
    }

    public void addConditions(LibConditionProvider condition, ResourceLocation ... recipes) {
        if (recipes.length == 0) {
            return;
        }
        for (ResourceLocation recipe : recipes) {
            this.conditions.computeIfAbsent(recipe, r -> new ArrayList()).add(condition);
        }
    }

    public void writeConditions(ResourceLocation id, JsonObject json) {
        if (this.conditions.containsKey(id)) {
            Services.CONDITIONS.write(json, this.conditions.get(id).toArray(new LibConditionProvider[0]));
        }
    }

    public abstract void registerConditions();

    public void m_245200_(Consumer<FinishedRecipe> recipeConsumer) {
        this.registerConditions();
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashSet recipes = Sets.newHashSet();
        ArrayList finishedRecipes = new ArrayList();
        this.m_245200_(curRecipe -> {
            if (!recipes.add(curRecipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + curRecipe.m_6445_());
            }
            JsonObject recipeJson = curRecipe.m_125966_();
            this.writeConditions(curRecipe.m_6445_(), recipeJson);
            finishedRecipes.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)recipeJson, (Path)this.f_236355_.m_245731_(curRecipe.m_6445_())));
            JsonObject advancementJson = curRecipe.m_5860_();
            if (advancementJson != null) {
                this.writeConditions(curRecipe.m_6445_(), advancementJson);
                finishedRecipes.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)advancementJson, (Path)this.f_236356_.m_245731_(curRecipe.m_6448_())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])finishedRecipes.toArray(CompletableFuture[]::new));
    }
}

